/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.list.GroupList;
import commvault.cte.component.GroupListModel;
import commvault.cte.component.MyTransferHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupListSelectionPanel<T, E>
extends JPanel {
    private LinkedHashMap<T, List<E>> availableMap;
    private LinkedHashMap<T, List<E>> selectedMap;
    public JButton addAllButton;
    public JButton addButton;
    public JButton removeButton;
    public JButton removeAllButton;
    private static DataFlavor dataFlavor;

    public GroupListSelectionPanel(LinkedHashMap<T, List<E>> linkedHashMap, LinkedHashMap<T, List<E>> linkedHashMap2, Comparator<E> comparator) {
        this.setLayout(new GridBagLayout());
        this.availableMap = linkedHashMap;
        this.selectedMap = linkedHashMap2;
        this.addAllButton = new JButton(">>");
        this.addButton = new JButton(">");
        this.removeButton = new JButton("<");
        this.removeAllButton = new JButton("<<");
        this.init(comparator);
    }

    private void init(Comparator<E> comparator) {
        final GroupListModel<T, E> groupListModel = new GroupListModel<T, E>(this.availableMap, comparator);
        final GroupList groupList = new GroupList(groupListModel);
        final GroupListModel<T, E> groupListModel2 = new GroupListModel<T, E>(this.selectedMap, comparator);
        final GroupList groupList2 = new GroupList(groupListModel2);
        groupList.setDragEnabled(true);
        groupList.setTransferHandler(new MyTransferHandler<T, E>(groupListModel));
        groupList.setSelectionMode(2);
        groupList.setVisibleRowCount(20);
        JScrollPane jScrollPane = new JScrollPane((Component)groupList);
        jScrollPane.setPreferredSize(new Dimension(300, 700));
        JPanel jPanel = new JPanel();
        jPanel.add(jScrollPane);
        groupList2.setDragEnabled(true);
        groupList2.setTransferHandler(new MyTransferHandler<T, E>(groupListModel2));
        groupList2.setSelectionMode(2);
        groupList2.setVisibleRowCount(20);
        JScrollPane jScrollPane2 = new JScrollPane((Component)groupList2);
        jScrollPane2.setPreferredSize(new Dimension(300, 700));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jScrollPane2);
        groupList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                    int n = groupList.getSelectedIndex();
                    groupListModel.moveElementsTo(groupListModel2, n);
                }
            }
        });
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                groupListModel.moveAllElementsTo(groupListModel2);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                groupListModel.moveElementsTo(groupListModel2, groupList.getSelectedIndices());
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                groupListModel2.moveElementsTo(groupListModel, groupList2.getSelectedIndices());
            }
        });
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                groupListModel2.moveAllElementsTo(groupListModel);
            }
        });
        groupList2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                    int n = groupList2.getSelectedIndex();
                    groupListModel2.moveElementsTo(groupListModel, n);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(20, 5, 0, 5);
        this.add((Component)this.getButtonPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 10, 10));
        jPanel.add(this.addAllButton);
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        jPanel.add(this.removeAllButton);
        return jPanel;
    }

    public static DataFlavor getDataFlavor() {
        if (dataFlavor == null) {
            try {
                dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return dataFlavor;
    }
}

