/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientPanel
extends JPanel {
    private int orientation = 1;
    Color gradientStart = new Color(245, 244, 242);
    Color gradientEnd = new Color(213, 210, 202);

    public GradientPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.init();
    }

    public GradientPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.init();
    }

    public GradientPanel(boolean bl) {
        super(bl);
        this.init();
    }

    public GradientPanel(Color color) {
        this(color, Color.white);
    }

    public GradientPanel(Color color, Color color2) {
        this.gradientStart = color;
        this.gradientEnd = color2;
    }

    public GradientPanel() {
        this.init();
    }

    private void init() {
        this.setOpaque(false);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (UIManager.getLookAndFeel().getName().equalsIgnoreCase("Windows")) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, this.getHeight(), this.gradientEnd);
            if (this.getOrientation() == 0) {
                gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientStart, this.getWidth(), 0.0f, this.gradientEnd);
            }
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(graphics);
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color color) {
        this.gradientStart = color;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color color) {
        this.gradientEnd = color;
    }
}

