/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatNumericDocument
extends PlainDocument {
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;
    private double validValue = 0.0;
    private int maxChars = -1;
    private boolean allowNonNumericValue;
    public static final int UNLIMITED_FRACTION_DIGITS = -1;
    protected int maxFracts = -1;

    public FloatNumericDocument() {
        this.minValue = Double.MIN_VALUE;
        this.maxValue = Double.MAX_VALUE;
    }

    public FloatNumericDocument(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
    }

    public FloatNumericDocument(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (this.getMaxChars() != -1) {
            try {
                if (string.length() + this.getContentString().length() > this.getMaxChars()) {
                    string = string.substring(0, this.getMaxChars() - this.getContentString().length());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String string2 = this.getContentString();
            String string3 = "";
            char c = '1';
            if (string.length() == 1) {
                c = string.charAt(0);
                string3 = string2.substring(0, n) + c + string2.substring(n);
            } else {
                super.insertString(n, string.substring(0, string.indexOf(46) + this.maxFracts + 1), attributeSet);
            }
            if (this.isMaximumFractionDigitsExceeded(string3, this.maxFracts, n)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.allowNonNumericValue) {
            super.insertString(n, string, attributeSet);
        } else {
            try {
                double d;
                int n2 = this.getStartPosition().getOffset();
                int n3 = this.getLength();
                String string4 = this.getText(n2, n3);
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.insert(n, string);
                double d2 = Double.parseDouble(stringBuffer.toString());
                double d3 = d = this.validValue < this.getMinValue() ? this.getMinValue() : this.validValue;
                if (d2 < this.getMinValue() || d2 > this.getMaxValue()) {
                    if (!(this.getFloatValue() < this.getMinValue()) && this.getContentString().length() != 0) {
                        return;
                    }
                    this.setLastKnownValidValue(d);
                    super.insertString(n, string, attributeSet);
                } else {
                    super.insertString(n, string, attributeSet);
                    this.setLastKnownValidValue(this.getFloatValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void recalculateValue() {
        try {
            int n = this.getStartPosition().getOffset();
            int n2 = this.getLength();
            float f = Float.parseFloat(super.getText(n, n2));
            if ((double)f < this.getMinValue() || (double)f > this.getMaxValue()) {
                super.remove(n, n2);
            }
            if ((double)f < this.getMinValue()) {
                super.insertString(0, Double.toString(this.getMinValue()), null);
            } else if ((double)f > this.getMaxValue()) {
                super.insertString(0, Double.toString(this.getMaxValue()), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxValue(float f) {
        this.maxValue = f;
        this.recalculateValue();
    }

    public void setMinValue(float f) {
        this.minValue = f;
        this.recalculateValue();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxValueReached() {
        return this.getMaxValue() <= this.getFloatValue();
    }

    public boolean isMinValueReached() {
        return this.getMinValue() >= this.getFloatValue();
    }

    public boolean isValidValue() {
        return !(this.getMaxValue() < this.getFloatValue()) && !(this.getMinValue() > this.getFloatValue());
    }

    public double getFloatValue() {
        try {
            return Double.parseDouble(this.getContentString());
        }
        catch (Exception exception) {
            return this.minValue;
        }
    }

    public String getContentString() throws Exception {
        int n = this.getStartPosition().getOffset();
        int n2 = this.getLength();
        return this.getText(n, n2);
    }

    public void setLastKnownValidValue(double d) {
        this.validValue = d;
    }

    public double getLastKnownValidValue() {
        return this.validValue;
    }

    public void resetToValidValue() {
        try {
            double d = this.getLastKnownValidValue();
            int n = this.getStartPosition().getOffset();
            int n2 = this.getLength();
            super.remove(n, n2);
            this.insertString(0, Double.toString(d), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMaxChars(int n) {
        this.maxChars = n;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.allowNonNumericValue = bl;
    }

    public boolean isAllowNonNumericValue() {
        return this.allowNonNumericValue;
    }

    public int getMaximumFractionDigits() {
        return this.maxFracts;
    }

    public void setMaximumFractionDigits(int n) {
        this.maxFracts = n;
    }

    public boolean isMaximumFractionDigitsExceeded(String string, int n, int n2) {
        if (string == null || string.length() == 0 || n == -1) {
            return false;
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!bl) {
                bl = string.charAt(i) == '.';
                continue;
            }
            if (!Character.isDigit(string.charAt(i))) continue;
            ++n3;
        }
        return n3 > n;
    }
}

