/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class AutoSuggestTextField
extends JTextField
implements DocumentListener {
    private JWindow thePopupWindow;
    private JList theItemList;
    private Point theRelativePosition;
    private FilteredList filter = null;
    private String separator = ";";
    private String pathSeparator = "\\";
    private List theItems;
    private ItemListModel theItemListModel;

    public AutoSuggestTextField(FilteredList filteredList) {
        this.filter = filteredList;
        this.getDocument().addDocumentListener(this);
        this.theItems = new LinkedList();
        this.theItemListModel = new ItemListModel();
        this.theItemList = new JList(this.theItemListModel){

            @Override
            public int getVisibleRowCount() {
                return Math.min(AutoSuggestTextField.this.theItemListModel.getSize(), 10);
            }
        };
        this.theItemList.setSelectionMode(0);
        this.theItemList.setFocusable(false);
        this.theItemList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AutoSuggestTextField.this.setNextItem(AutoSuggestTextField.this.theItemList.getSelectedValue());
                }
            }
        });
        this.theItemList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AutoSuggestTextField.this.setNextItem(AutoSuggestTextField.this.theItemList.getSelectedValue());
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 2), "controlEspace");
        inputMap.put(KeyStroke.getKeyStroke(36, 2), "home");
        inputMap.put(KeyStroke.getKeyStroke(35, 2), "end");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("controlEspace", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoSuggestTextField.this.onControlSpace();
            }
        });
        actionMap.put("home", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoSuggestTextField.this.moveStart();
            }
        });
        actionMap.put("end", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoSuggestTextField.this.moveEnd();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (AutoSuggestTextField.this.isAutoCompleting()) {
                    AutoSuggestTextField.this.stopAutoCompletion();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AutoSuggestTextField.this.isAutoCompleting()) {
                    AutoSuggestTextField.this.stopAutoCompletion();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed() || !AutoSuggestTextField.this.isAutoCompleting()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        AutoSuggestTextField.this.setNextItem(AutoSuggestTextField.this.theItemList.getSelectedValue());
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        AutoSuggestTextField.this.moveDown();
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        AutoSuggestTextField.this.moveUp();
                        keyEvent.consume();
                        break;
                    }
                    case 34: {
                        AutoSuggestTextField.this.movePageDown();
                        keyEvent.consume();
                        break;
                    }
                    case 33: {
                        AutoSuggestTextField.this.movePageUp();
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    private void moveDown() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        int n2 = this.theItemList.getSelectedIndex();
        if (++n2 > n - 1) {
            n2 = 0;
        }
        this.theItemList.setSelectionInterval(n2, n2);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(n2, n2));
    }

    private void moveUp() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        int n2 = this.theItemList.getSelectedIndex();
        if (--n2 < 0) {
            n2 = n - 1;
        }
        this.theItemList.setSelectionInterval(n2, n2);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(n2, n2));
    }

    private void moveStart() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        this.theItemList.setSelectionInterval(0, 0);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(0, 0));
    }

    private void moveEnd() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        int n2 = n - 1;
        this.theItemList.setSelectionInterval(n2, n2);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(n2, n2));
    }

    private void movePageUp() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        int n2 = this.theItemList.getSelectedIndex();
        int n3 = Math.max(0, n2 - Math.max(0, this.theItemList.getVisibleRowCount() - 1));
        this.theItemList.setSelectionInterval(n3, n3);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(n3, n3));
    }

    private void movePageDown() {
        int n = this.theItemListModel.getSize();
        if (n < 1) {
            return;
        }
        int n2 = this.theItemList.getSelectedIndex();
        int n3 = Math.min(n - 1, n2 + Math.max(0, this.theItemList.getVisibleRowCount() - 1));
        this.theItemList.setSelectionInterval(n3, n3);
        this.theItemList.scrollRectToVisible(this.theItemList.getCellBounds(n3, n3));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.isAutoCompleting()) {
            return;
        }
        this.updateItems();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.isAutoCompleting()) {
            return;
        }
        this.updateItems();
    }

    private boolean isAutoCompleting() {
        if (this.thePopupWindow == null) {
            return false;
        }
        return this.thePopupWindow.isVisible();
    }

    private void startAutoCompletion() {
        this.prepareAutoCompletion();
        this.updateItems();
    }

    private void setCurrentItem(Object object) {
        String string = this.getText();
        String string2 = this.separator;
        int n = string.lastIndexOf(string2);
        int n2 = string.lastIndexOf(this.pathSeparator);
        if (n2 >= 0 && n2 > n) {
            n = n2;
        }
        string = n >= 0 ? string.substring(0, n + 1) : "";
        String string3 = string + object.toString();
        if (object instanceof TreeItem) {
            string2 = this.pathSeparator;
        }
        if (!string3.endsWith(string2)) {
            string3 = string3 + string2;
        }
        this.setText(string3);
        this.setCaretPosition(this.getText().length());
    }

    private void setNextItem(Object object) {
        this.getDocument().removeDocumentListener(this);
        this.setCurrentItem(object);
        this.getDocument().addDocumentListener(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoSuggestTextField.this.startAutoCompletion();
            }
        });
    }

    private void onControlSpace() {
        if (!this.isAutoCompleting()) {
            this.startAutoCompletion();
        }
    }

    private void setItems(Object[] objectArray) {
        int n = this.theItems.size();
        if (n > 0) {
            this.theItems.clear();
            this.theItemListModel.fireCleared(n);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.theItems.add(objectArray[i]);
            }
        }
        if ((n = this.theItems.size()) > 0) {
            this.theItemListModel.fireFilled(n);
        }
        this.theItemList.setSelectedIndex(0);
        this.thePopupWindow.pack();
        this.thePopupWindow.pack();
    }

    private void updateItems() {
        Object[] objectArray;
        String string = this.getText();
        int n = string.lastIndexOf(this.separator);
        if (n < 0) {
            n = 0;
        } else {
            string = string.substring(n + 1);
        }
        int n2 = string.lastIndexOf(this.pathSeparator);
        String string2 = "";
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            n = this.getText().lastIndexOf(this.pathSeparator);
        }
        if ((objectArray = this.filter.getFilteredList(string2, string).toArray()).length == 0) {
            if (this.isAutoCompleting()) {
                this.stopAutoCompletion();
            }
            return;
        }
        this.setItems(objectArray);
        Rectangle rectangle = null;
        try {
            rectangle = this.getUI().modelToView(this, n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (rectangle == null) {
            return;
        }
        this.theRelativePosition = new Point(rectangle.x, rectangle.y + rectangle.height);
        Point point = this.getLocationOnScreen();
        Point point2 = new Point(point.x + this.theRelativePosition.x, point.y + this.theRelativePosition.y);
        point2 = AutoSuggestTextField.relocatePopupWindow(point2, this.thePopupWindow);
        this.thePopupWindow.setLocation(point2);
        if (!this.isAutoCompleting()) {
            this.thePopupWindow.setVisible(true);
            this.requestFocus();
        }
    }

    private void stopAutoCompletion() {
        this.setItems(new Object[0]);
        this.thePopupWindow.setVisible(false);
    }

    private void placePopupWindow() {
        if (this.theRelativePosition == null) {
            return;
        }
        Point point = this.getLocationOnScreen();
        Point point2 = new Point(point.x + this.theRelativePosition.x, point.y + this.theRelativePosition.y);
        point2 = AutoSuggestTextField.relocatePopupWindow(point2, this.thePopupWindow);
        this.thePopupWindow.setLocation(point2);
    }

    private void prepareAutoCompletion() {
        if (this.thePopupWindow == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this.thePopupWindow = new JWindow(window);
            JScrollPane jScrollPane = new JScrollPane(this.theItemList, 20, 31);
            jScrollPane.setBorder(BorderFactory.createBevelBorder(0));
            this.thePopupWindow.setContentPane(jScrollPane);
            window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    AutoSuggestTextField.this.stopAutoCompletion();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (AutoSuggestTextField.this.isAutoCompleting()) {
                        AutoSuggestTextField.this.placePopupWindow();
                    }
                }
            });
            this.theItemList.setFont(this.getFont());
        }
    }

    private static Point relocatePopupWindow(Point point, JWindow jWindow) {
        int n;
        Dimension dimension = jWindow.getSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(jWindow.getGraphicsConfiguration());
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = new Dimension(dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
        Point point2 = new Point(point);
        if (dimension.width < dimension3.width && (n = insets.left + dimension3.width - (point2.x + dimension.width)) < 0) {
            point2.x = Math.max(insets.left, point2.x + n);
        }
        if (dimension.height < dimension3.height && (n = insets.top + dimension3.height - (point2.y + dimension.height)) < 0) {
            point2.y = Math.max(insets.top, point2.y + n);
        }
        return point2;
    }

    public static class TreeItem {
        private Object object;
        private String sep;

        public TreeItem(Object object, String string) {
            this.object = object;
            this.sep = string;
        }

        public String toString() {
            return this.object.toString();
        }

        public String getSeparator() {
            return this.sep;
        }
    }

    public static interface FilteredList {
        public List getFilteredList(String var1, String var2);
    }

    private class ItemListModel
    extends AbstractListModel {
        private ItemListModel() {
        }

        @Override
        public int getSize() {
            return AutoSuggestTextField.this.theItems.size();
        }

        @Override
        public Object getElementAt(int n) {
            return AutoSuggestTextField.this.theItems.get(n);
        }

        public void fireCleared(int n) {
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        public void fireFilled(int n) {
            this.fireIntervalAdded(this, 0, n - 1);
        }
    }
}

