/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.common.SwingWorkerEx;
import commvault.cte.component.LayoutUtils;
import commvault.cte.util.Application;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractDelayedLoadablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel loadingLabel;
    private JComponent content;

    public AbstractDelayedLoadablePanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.loadingLabel = new JLabel(CteStringBank.LOADING_DOTS.getI18n(), Application.instance().getIconSource().getIcon("Progress-Blue"), 0);
        LayoutUtils.addRow(this, this.loadingLabel);
    }

    protected abstract void loadData();

    public void setContentComponent(JComponent jComponent) {
        this.content = jComponent;
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public void loadDataAndRefresh() {
        final AbstractDelayedLoadablePanel abstractDelayedLoadablePanel = this;
        new SwingWorkerEx<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                AbstractDelayedLoadablePanel.this.loadData();
                return null;
            }

            @Override
            protected void done() {
                if (AbstractDelayedLoadablePanel.this.content != null) {
                    AbstractDelayedLoadablePanel.this.removeAll();
                    AbstractDelayedLoadablePanel.this.setLayout(new GridBagLayout());
                    LayoutUtils.addRow((Container)abstractDelayedLoadablePanel, AbstractDelayedLoadablePanel.this.content, true, true);
                    AbstractDelayedLoadablePanel.this.revalidate();
                }
            }
        }.execute();
    }

    public JLabel getLoadingLabel() {
        return this.loadingLabel;
    }
}

