/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryEncodingType;
import commvault.cte.common.xml.BinaryPrimitiveType;

public class BinaryEncodingSelector {
    private BinaryEncodingType[] encodingMap = new BinaryEncodingType[20];
    private BinaryPrimitiveType[] BinaryPrimitiveMap = new BinaryPrimitiveType[20];
    private BinaryEncodingType keyEncodingType;
    private BinaryEncodingType sizeEncodingType;
    private static final int max_type_ = 20;
    private static final int unknown_ = 20;
    static BinaryEncodingSelector instance = null;

    public static BinaryEncodingSelector getInstance() {
        if (instance == null) {
            instance = new BinaryEncodingSelector();
        }
        return instance;
    }

    private BinaryEncodingSelector() {
        this.encodingMap[BinaryPrimitiveType.unknown_.getEnumValue()] = BinaryEncodingType.UNDEF;
        this.encodingMap[BinaryPrimitiveType.int_.getEnumValue()] = BinaryEncodingType.SVARINT;
        this.encodingMap[BinaryPrimitiveType.uint_.getEnumValue()] = BinaryEncodingType.VARINT;
        this.encodingMap[BinaryPrimitiveType.long_.getEnumValue()] = BinaryEncodingType.SVARINT;
        this.encodingMap[BinaryPrimitiveType.ulong_.getEnumValue()] = BinaryEncodingType.VARINT;
        this.encodingMap[BinaryPrimitiveType.longlong_.getEnumValue()] = BinaryEncodingType.FIXED64;
        this.encodingMap[BinaryPrimitiveType.float_.getEnumValue()] = BinaryEncodingType.FIXED32;
        this.encodingMap[BinaryPrimitiveType.double_.getEnumValue()] = BinaryEncodingType.FIXED64;
        this.encodingMap[BinaryPrimitiveType.string_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.wstring_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.bstring_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.boolean_.getEnumValue()] = BinaryEncodingType.VARINT;
        this.encodingMap[BinaryPrimitiveType.pstring_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.class_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.list_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.cdata_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.xml_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.map_.getEnumValue()] = BinaryEncodingType.VARSIZE;
        this.encodingMap[BinaryPrimitiveType.cv_time32_t_.getEnumValue()] = BinaryEncodingType.SVARINT;
        this.encodingMap[BinaryPrimitiveType.cv_time64_t_.getEnumValue()] = BinaryEncodingType.FIXED64;
        this.BinaryPrimitiveMap[0] = BinaryPrimitiveType.unknown_;
        this.BinaryPrimitiveMap[1] = BinaryPrimitiveType.int_;
        this.BinaryPrimitiveMap[2] = BinaryPrimitiveType.uint_;
        this.BinaryPrimitiveMap[3] = BinaryPrimitiveType.long_;
        this.BinaryPrimitiveMap[4] = BinaryPrimitiveType.ulong_;
        this.BinaryPrimitiveMap[5] = BinaryPrimitiveType.longlong_;
        this.BinaryPrimitiveMap[6] = BinaryPrimitiveType.float_;
        this.BinaryPrimitiveMap[7] = BinaryPrimitiveType.double_;
        this.BinaryPrimitiveMap[8] = BinaryPrimitiveType.string_;
        this.BinaryPrimitiveMap[9] = BinaryPrimitiveType.wstring_;
        this.BinaryPrimitiveMap[10] = BinaryPrimitiveType.bstring_;
        this.BinaryPrimitiveMap[11] = BinaryPrimitiveType.boolean_;
        this.BinaryPrimitiveMap[12] = BinaryPrimitiveType.pstring_;
        this.BinaryPrimitiveMap[13] = BinaryPrimitiveType.class_;
        this.BinaryPrimitiveMap[14] = BinaryPrimitiveType.list_;
        this.BinaryPrimitiveMap[15] = BinaryPrimitiveType.cdata_;
        this.BinaryPrimitiveMap[16] = BinaryPrimitiveType.xml_;
        this.BinaryPrimitiveMap[17] = BinaryPrimitiveType.map_;
        this.BinaryPrimitiveMap[18] = BinaryPrimitiveType.cv_time32_t_;
        this.BinaryPrimitiveMap[19] = BinaryPrimitiveType.cv_time64_t_;
        this.keyEncodingType = BinaryEncodingType.FIXED32;
        this.sizeEncodingType = BinaryEncodingType.VARINT;
    }

    public boolean OverrideEncodingForType(int n, BinaryEncodingType binaryEncodingType) {
        boolean bl = false;
        if (n > 20 && n < 20) {
            this.encodingMap[n] = binaryEncodingType;
            bl = true;
        }
        return bl;
    }

    public boolean OverrideEncodingForKey(BinaryEncodingType binaryEncodingType) {
        boolean bl = false;
        if (binaryEncodingType == BinaryEncodingType.VARINT || binaryEncodingType == BinaryEncodingType.FIXED32 || binaryEncodingType == BinaryEncodingType.FIXED64) {
            this.keyEncodingType = binaryEncodingType;
            bl = true;
        }
        return bl;
    }

    public boolean OverrideEncodingForSize(BinaryEncodingType binaryEncodingType) {
        boolean bl = false;
        if (binaryEncodingType == BinaryEncodingType.VARINT || binaryEncodingType == BinaryEncodingType.FIXED32 || binaryEncodingType == BinaryEncodingType.FIXED64) {
            this.sizeEncodingType = binaryEncodingType;
            bl = true;
        }
        return bl;
    }

    public BinaryEncodingType getEncodingForType(int n) {
        BinaryEncodingType binaryEncodingType = BinaryEncodingType.VARSIZE;
        if (n < 20) {
            binaryEncodingType = this.encodingMap[n];
        }
        return binaryEncodingType;
    }

    public BinaryEncodingType getEncodingForKey() {
        return this.keyEncodingType;
    }

    public BinaryPrimitiveType getPrimitiveType(int n) {
        if (n < 20 && n > 0) {
            return this.BinaryPrimitiveMap[n];
        }
        return BinaryPrimitiveType.unknown_;
    }

    public BinaryEncodingType getEncodingForSize() {
        return this.sizeEncodingType;
    }
}

