/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.wsdl;

import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.Message;
import commvault.cte.common.wsdl.PortType;
import commvault.cte.common.wsdl.Service;
import commvault.cte.common.wsdl.WSDLException;
import commvault.cte.common.wsdl.WSDLImport;
import commvault.cte.common.wsdl.WSDLSystem;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.DOMOutputter;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Node;

public class WSDLDocument {
    private WSDLSystem wsdlSystem;
    private Document document;
    private Element rootElement;
    protected Namespace targetNamespace;
    protected Namespace schemaSoapNS;
    protected Namespace schemaSoap12NS;
    protected Namespace schemaHttpNS;
    protected Namespace schemaMimeNS;
    protected Namespace schemaWSAddressingNS;

    protected static WSDLDocument parse(URL uRL, WSDLSystem wSDLSystem) throws Exception {
        return WSDLDocument.parse(uRL.openStream(), wSDLSystem);
    }

    protected static WSDLDocument parse(InputStream inputStream, WSDLSystem wSDLSystem) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(inputStream);
        WSDLDocument wSDLDocument = new WSDLDocument(document, wSDLSystem);
        inputStream.close();
        return wSDLDocument;
    }

    protected WSDLDocument(Document document, WSDLSystem wSDLSystem) throws Exception {
        this.document = document;
        this.wsdlSystem = wSDLSystem;
        this.rootElement = document.getRootElement();
        if (this.rootElement.getNamespace() == null) {
            throw new WSDLException("invalid WSDL document");
        }
        if (!this.rootElement.getNamespace().getURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            throw new WSDLException("invalid wsdl namespace [" + this.rootElement.getNamespace().getURI() + "]");
        }
        this.targetNamespace = this.retrieveTargetNS();
        this.schemaSoapNS = this.findNamespace("http://schemas.xmlsoap.org/wsdl/soap/");
        this.schemaSoap12NS = this.findNamespace("http://schemas.xmlsoap.org/wsdl/soap12/");
        this.schemaHttpNS = this.findNamespace("http://schemas.xmlsoap.org/wsdl/http/");
        this.schemaMimeNS = this.findNamespace("http://schemas.xmlsoap.org/wsdl/mime/");
        this.schemaWSAddressingNS = this.findNamespace("http://www.w3.org/2006/05/addressing/wsdl");
    }

    protected List<WSDLImport> getImports() throws Exception {
        ArrayList<WSDLImport> arrayList = new ArrayList<WSDLImport>();
        for (Element element : this.rootElement.getChildren("import", this.rootElement.getNamespace())) {
            arrayList.add(new WSDLImport(element));
        }
        return arrayList;
    }

    protected List<Element> getSchema() throws Exception {
        Element element = this.rootElement.getChild("types", this.rootElement.getNamespace());
        Namespace namespace = this.findNamespace("http://www.w3.org/2001/XMLSchema");
        new XMLOutputter();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element2 : element.getChildren("schema", namespace)) {
            for (Namespace namespace2 : this.rootElement.getAdditionalNamespaces()) {
                element2.addNamespaceDeclaration(namespace2);
            }
            arrayList.add(element2);
        }
        return arrayList;
    }

    protected void parseMessages(Map<QName, Message> map) throws Exception {
        for (Element element : this.rootElement.getChildren("message", this.rootElement.getNamespace())) {
            Message message = new Message(this, element);
            map.put(message.getName(), message);
            message.parse();
        }
    }

    protected void parsePortTypes(Map<QName, PortType> map) throws Exception {
        for (Element element : this.rootElement.getChildren("portType", this.rootElement.getNamespace())) {
            PortType portType = new PortType(this, element);
            map.put(portType.getName(), portType);
            portType.parse();
        }
    }

    protected void parseBindings(Map<QName, Binding> map) throws Exception {
        for (Element element : this.rootElement.getChildren("binding", this.rootElement.getNamespace())) {
            Binding binding = Binding.newInstance(this, element);
            if (binding == null) continue;
            map.put(binding.getName(), binding);
            binding.parse();
        }
    }

    protected void parseServices(Map<QName, Service> map) throws Exception {
        for (Element element : this.rootElement.getChildren("service", this.rootElement.getNamespace())) {
            Service service = new Service(this, element);
            map.put(service.getName(), service);
            service.parse();
        }
    }

    public Message getMessage(QName qName) {
        return this.wsdlSystem.getMessage(qName);
    }

    public PortType getPortType(QName qName) {
        return this.wsdlSystem.getPortType(qName);
    }

    public Binding getBinding(QName qName) {
        return this.wsdlSystem.getBinding(qName);
    }

    public Namespace getTargetNamespace() {
        return this.targetNamespace;
    }

    protected SchemaElement findElement(QName qName) {
        return this.wsdlSystem.findElement(qName);
    }

    protected SchemaType findType(QName qName) {
        return this.wsdlSystem.findType(qName);
    }

    protected QName retrieveName(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length == 2) {
            Namespace namespace = this.rootElement.getNamespace(stringArray[0]);
            return new QName(namespace.getURI(), stringArray[1], stringArray[0]);
        }
        if (stringArray.length == 1) {
            return new QName(this.getTargetNamespace().getURI(), string, this.getTargetNamespace().getPrefix());
        }
        return null;
    }

    private Namespace retrieveTargetNS() {
        if (this.rootElement.getAttribute("targetNamespace") != null) {
            String string = this.rootElement.getAttributeValue("targetNamespace");
            return this.findNamespace(string);
        }
        return null;
    }

    private Namespace findNamespace(String string) {
        for (Namespace namespace : this.rootElement.getAdditionalNamespaces()) {
            if (!namespace.getURI().equalsIgnoreCase(string)) continue;
            return namespace;
        }
        return null;
    }

    public String getXml() throws Exception {
        XMLOutputter xMLOutputter = new XMLOutputter();
        StringWriter stringWriter = new StringWriter();
        xMLOutputter.output(this.document, (Writer)stringWriter);
        stringWriter.close();
        return stringWriter.toString();
    }

    public static Node convertDom(Element element) throws Exception {
        Document document = new Document();
        document.addContent((Content)element.clone());
        DOMOutputter dOMOutputter = new DOMOutputter();
        return dOMOutputter.output(document).getDocumentElement();
    }
}

