/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.workflow;

import commvault.cte.common.workflow.WorkflowSchema;
import commvault.cte.util.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ExpressionParser {
    private String expressionValue;
    private int appendStartIndex = 0;
    private ExpressionContainer nextExpression = null;

    public ExpressionParser(String string) {
        this.expressionValue = string;
    }

    public boolean find() {
        int n = 0;
        if (this.nextExpression != null) {
            n = this.nextExpression.endIndex;
        }
        this.nextExpression = null;
        List<TagContainer> list = this.findAllTags(n, WorkflowSchema.EXPRESSION_START_TAGS);
        if (list.size() == 0) {
            return false;
        }
        List<TagContainer> list2 = this.findAllTags(n, WorkflowSchema.EXPRESSION_END_TAGS);
        if (list2.size() == 0) {
            throw new Error("error parsing string for expressions");
        }
        ArrayList<ExpressionContainer> arrayList = new ArrayList<ExpressionContainer>();
        for (TagContainer tagContainer : list) {
            arrayList.add(new ExpressionContainer(tagContainer));
        }
        this.getNextExpression(arrayList, list2, null);
        if (this.nextExpression == null || this.nextExpression.endIndex == -1) {
            this.getNextExpression(arrayList, list2, String.valueOf('}'));
        }
        if (this.nextExpression == null || this.nextExpression.endIndex == -1) {
            throw new Error("error parsing string for expressions");
        }
        this.nextExpression.expression = this.expressionValue.substring(this.nextExpression.startIndex, this.nextExpression.endIndex);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void getNextExpression(List<ExpressionContainer> list, List<TagContainer> list2, String string) {
        char[] cArray = this.expressionValue.toCharArray();
        LinkedList<ExpressionContainer> linkedList = new LinkedList<ExpressionContainer>();
        for (int i = 0; i < cArray.length; ++i) {
            void var9_12;
            Object object;
            for (ExpressionContainer expressionContainer : list) {
                if (expressionContainer.startIndex != i) continue;
                linkedList.add(expressionContainer);
            }
            if (linkedList.size() <= 0) continue;
            ExpressionContainer expressionContainer = (ExpressionContainer)linkedList.getLast();
            if (string != null) {
                object = string;
            } else if (expressionContainer.tag.equalsIgnoreCase("xpath:{")) {
                object = "}";
            } else if (expressionContainer.tag.equalsIgnoreCase("java:{")) {
                object = "}:java";
            } else if (expressionContainer.tag.equalsIgnoreCase("js:{")) {
                object = "}:js";
            } else if (expressionContainer.tag.equalsIgnoreCase("jython:{")) {
                object = "}:jython";
            } else if (expressionContainer.tag.equalsIgnoreCase("groovy:{")) {
                object = "}:groovy";
            } else {
                throw new Error("unknown end tag for start tag [" + expressionContainer.tag + "]");
            }
            Object var9_11 = null;
            for (TagContainer tagContainer : list2) {
                if (tagContainer.startIndex != i || !tagContainer.tag.equalsIgnoreCase((String)object)) continue;
                TagContainer tagContainer2 = tagContainer;
            }
            if (var9_12 == null) continue;
            ExpressionContainer expressionContainer2 = (ExpressionContainer)linkedList.pollLast();
            if (linkedList.size() != 0) continue;
            this.nextExpression = expressionContainer2;
            this.nextExpression.endTag = (String)object;
            this.nextExpression.endIndex = i + ((String)object).length();
            return;
        }
    }

    public String group() {
        if (this.nextExpression == null) {
            return null;
        }
        return this.nextExpression.expression;
    }

    public void appendReplacement(StringBuffer stringBuffer, String string) {
        String string2 = this.expressionValue.substring(this.appendStartIndex, this.nextExpression.endIndex);
        stringBuffer.append(Utils.replace(string2, this.nextExpression.expression, string));
        this.appendStartIndex = this.nextExpression.endIndex;
    }

    public void appendTail(StringBuffer stringBuffer) {
        if (this.appendStartIndex < this.expressionValue.length()) {
            stringBuffer.append(this.expressionValue.substring(this.appendStartIndex));
        }
    }

    private List<TagContainer> findAllTags(int n, String[] stringArray) {
        ArrayList<TagContainer> arrayList = new ArrayList<TagContainer>();
        TagContainer tagContainer = this.nextTag(n, stringArray);
        if (tagContainer == null) {
            return arrayList;
        }
        do {
            arrayList.add(tagContainer);
        } while ((tagContainer = this.nextTag(tagContainer.startIndex + 1, stringArray)) != null);
        return arrayList;
    }

    private TagContainer nextTag(int n, String[] stringArray) {
        TagContainer tagContainer = null;
        for (String string : stringArray) {
            int n2 = this.expressionValue.toLowerCase().indexOf(string.toLowerCase(), n);
            if (n2 <= -1) continue;
            if (tagContainer == null) {
                tagContainer = new TagContainer(string, n2);
                continue;
            }
            if (n2 >= tagContainer.startIndex) continue;
            tagContainer = new TagContainer(string, n2);
        }
        return tagContainer;
    }

    private class ExpressionContainer {
        private String tag;
        private String endTag;
        private int startIndex;
        private int endIndex;
        private String expression;

        private ExpressionContainer(TagContainer tagContainer) {
            this(tagContainer.tag, tagContainer.startIndex);
        }

        private ExpressionContainer(String string, int n) {
            this.tag = string;
            this.startIndex = n;
            this.endIndex = -1;
        }

        public String toString() {
            return this.tag;
        }
    }

    private class TagContainer {
        private String tag;
        private int startIndex;

        private TagContainer(String string, int n) {
            this.tag = string;
            this.startIndex = n;
        }

        public String toString() {
            return this.tag;
        }
    }
}

