/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.schema.XmlElement;
import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.ClientGroupEntity;
import commvault.msgs.CvEntities.CommCellEntity;
import commvault.msgs.CvEntities.CredentialEntity;
import commvault.msgs.CvEntities.ExternalGroupEntity;
import commvault.msgs.CvEntities.LibraryEntity;
import commvault.msgs.CvEntities.MediaAgentEntity;
import commvault.msgs.CvEntities.SchedulePolicyEntity;
import commvault.msgs.CvEntities.StoragePolicyEntity;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.UserGroupEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import commvault.msgs.Workflow.ActivitySchema;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import workflow.types.XML;

public class SchemaUtils {
    public static boolean isValidName(String string) {
        try {
            new Element(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String formatName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (c == ' ' || c == '_') {
                stringBuffer.append("_");
                continue;
            }
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && (c < '0' || c > '9')) continue;
            if (stringBuffer.length() == 0 && c >= '0' && c <= '9') {
                stringBuffer.append("A");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String buildType(Class clazz) {
        GenericTypes genericTypes = GenericTypes.fromClass(clazz);
        if (genericTypes != null) {
            return genericTypes.getName().toString();
        }
        return new QName(clazz.getPackage().getName(), clazz.getSimpleName()).toString();
    }

    public static ActivitySchema getActivitySchema(String string, String string2, SchemaTypeSystem schemaTypeSystem) throws Exception {
        ActivitySchema activitySchema = new ActivitySchema();
        if (string == null || string.length() == 0) {
            return activitySchema;
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build((Reader)new StringReader(string));
        SchemaDocument schemaDocument = SchemaTypeSystem.parse(document.getRootElement(), schemaTypeSystem);
        SchemaType schemaType = schemaDocument.getType(string2);
        if (schemaType == null) {
            return activitySchema;
        }
        if (schemaType.getProperties() != null) {
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                if (schemaProperty.getName().getLocalPart().equalsIgnoreCase("inputs")) {
                    activitySchema.setInputs(SchemaEncoder.encode(schemaProperty));
                    continue;
                }
                if (!schemaProperty.getName().getLocalPart().equalsIgnoreCase("outputs")) continue;
                activitySchema.setOutputs(SchemaEncoder.encode(schemaProperty));
            }
        }
        return activitySchema;
    }

    public static boolean containsParentType(String string, XMLSchema xMLSchema) {
        if (string.length() > 0 && xMLSchema.getType().length() > 0 && string.equalsIgnoreCase(xMLSchema.getType())) {
            return true;
        }
        if (xMLSchema.getParent(false) == null) {
            return false;
        }
        return SchemaUtils.containsParentType(string, xMLSchema.getParent());
    }

    public static XMLSchema getSchema(Class clazz) {
        if (CTEProcessingModel.class.isAssignableFrom(clazz)) {
            return SchemaUtils.getMessageSchema(clazz);
        }
        return SchemaUtils.getBasicSchema(clazz);
    }

    private static XMLSchema getBasicSchema(Class clazz) {
        XMLSchema xMLSchema = new XMLSchema();
        xMLSchema.setName(clazz.getSimpleName());
        xMLSchema.setClassName(clazz.getName());
        xMLSchema.setInputType(clazz.getName());
        xMLSchema.setType(SchemaUtils.buildType(clazz));
        return xMLSchema;
    }

    public static XMLSchema getMessageSchema(Class clazz) {
        if (clazz.equals(ClientEntity.class)) {
            return SchemaUtils.getEntitySchema(ClientEntity.class, "clientName", "displayName", "clientId");
        }
        if (clazz.equals(ClientGroupEntity.class)) {
            return SchemaUtils.getEntitySchema(ClientGroupEntity.class, "clientGroupName", "clientGroupId");
        }
        if (clazz.equals(CommCellEntity.class)) {
            return SchemaUtils.getEntitySchema(CommCellEntity.class, "commCellName", "commCellId");
        }
        if (clazz.equals(LibraryEntity.class)) {
            return SchemaUtils.getEntitySchema(LibraryEntity.class, "libraryName", "libraryId");
        }
        if (clazz.equals(CredentialEntity.class)) {
            return SchemaUtils.getEntitySchema(CredentialEntity.class, "credentialName", "credentialId");
        }
        if (clazz.equals(MediaAgentEntity.class)) {
            return SchemaUtils.getEntitySchema(MediaAgentEntity.class, "mediaAgentName", "mediaAgentId");
        }
        if (clazz.equals(StoragePolicyEntity.class)) {
            return SchemaUtils.getEntitySchema(StoragePolicyEntity.class, "storagePolicyName", "storagePolicyId");
        }
        if (clazz.equals(SchedulePolicyEntity.class)) {
            return SchemaUtils.getEntitySchema(SchedulePolicyEntity.class, "schedulePolicyName", "schedulePolicyId");
        }
        if (clazz.equals(ExternalGroupEntity.class)) {
            return SchemaUtils.getEntitySchema(ExternalGroupEntity.class, "externalGroupName", "groupId");
        }
        if (clazz.equals(UserEntity.class)) {
            return SchemaUtils.getEntitySchema(UserEntity.class, "userName", "userId");
        }
        if (clazz.equals(UserGroupEntity.class)) {
            return SchemaUtils.getEntitySchema(UserGroupEntity.class, "userGroupName", "userGroupId");
        }
        if (clazz.equals(WorkflowEntity.class)) {
            return SchemaUtils.getEntitySchema(WorkflowEntity.class, "workflowName", "workflowId");
        }
        return SchemaUtils.getBasicSchema(clazz);
    }

    public static XMLSchema getEntitySchema(Class clazz, String string, String string2) {
        return SchemaUtils.getEntitySchema(clazz, string, null, string2);
    }

    public static XMLSchema getEntitySchema(Class clazz, String string, String string2, String string3) {
        XMLSchema xMLSchema;
        XMLSchema xMLSchema2 = SchemaUtils.getBasicSchema(clazz);
        XMLSchema xMLSchema3 = SchemaUtils.getBasicSchema(String.class);
        xMLSchema3.setName(string);
        xMLSchema2.getChildren().add(xMLSchema3);
        if (string2 != null) {
            xMLSchema = SchemaUtils.getBasicSchema(String.class);
            xMLSchema.setName(string2);
            xMLSchema2.getChildren().add(xMLSchema);
        }
        xMLSchema = SchemaUtils.getBasicSchema(Integer.class);
        xMLSchema.setName(string3);
        xMLSchema2.getChildren().add(xMLSchema);
        return xMLSchema2;
    }

    public static void updateAttributes(Element element, XMLSchema xMLSchema) {
        SchemaUtils.updateAttributes(XmlElement.load(element), xMLSchema);
    }

    public static void updateAttributes(XML xML, XMLSchema xMLSchema) {
        SchemaUtils.updateChildAttributes(xML.getChildren(), xMLSchema);
    }

    private static void updateChildAttributes(List<XML> list, XMLSchema xMLSchema) {
        for (XML xML : list) {
            XMLSchema xMLSchema2 = SchemaUtils.getChild(xMLSchema, xML.getName());
            if (xMLSchema2 == null) continue;
            if (xMLSchema2.getClassName().equalsIgnoreCase(Date.class.getName())) {
                xML.setAttribute("class", Calendar.class.getName());
            } else {
                xML.setAttribute("class", xMLSchema2.getClassName());
            }
            xML.setAttribute("_list_", String.valueOf(xMLSchema2.getListType()));
            SchemaUtils.updateChildAttributes(xML.getChildren(), xMLSchema2);
        }
    }

    public static void clearParent(XMLSchema xMLSchema) {
        xMLSchema.setParent(null);
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            SchemaUtils.clearParent(xMLSchema2);
        }
    }

    public static XMLSchema copySchema(XMLSchema xMLSchema, String string) {
        XMLSchema xMLSchema2 = new XMLSchema(xMLSchema);
        xMLSchema2.setName(string);
        return xMLSchema2;
    }

    public static XMLSchema getChild(XMLSchema xMLSchema, String string) {
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            if (!xMLSchema2.getName().equalsIgnoreCase(string)) continue;
            return xMLSchema2;
        }
        return null;
    }

    public static XMLSchema addChild(XMLSchema xMLSchema, String string, Class clazz) {
        XMLSchema xMLSchema2 = SchemaUtils.getSchema(clazz);
        xMLSchema2.setName(string);
        SchemaUtils.removeChild(xMLSchema, string);
        xMLSchema.getChildren().add(xMLSchema2);
        return xMLSchema2;
    }

    public static void addChild(XMLSchema xMLSchema, XMLSchema xMLSchema2) {
        SchemaUtils.addChild(xMLSchema, xMLSchema2, true);
    }

    public static void addChild(XMLSchema xMLSchema, XMLSchema xMLSchema2, boolean bl) {
        if (bl) {
            SchemaUtils.removeChild(xMLSchema, xMLSchema2.getName());
            xMLSchema.getChildren().add(xMLSchema2);
        } else if (SchemaUtils.getChild(xMLSchema, xMLSchema2.getName()) == null) {
            xMLSchema.getChildren().add(xMLSchema2);
        }
    }

    public static boolean removeChild(XMLSchema xMLSchema, String string) {
        boolean bl = false;
        Iterator iterator = xMLSchema.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLSchema xMLSchema2 = (XMLSchema)iterator.next();
            if (!xMLSchema2.getName().equalsIgnoreCase(string)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }
}

