/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.util.GDate;
import commvault.cte.common.schema.util.GDateBuilder;
import commvault.cte.common.schema.util.GDuration;
import commvault.cte.common.schema.util.GDurationSpecification;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class GDurationBuilder
implements GDurationSpecification,
Serializable {
    private static final long serialVersionUID = 1L;
    private int _sign;
    private int _CY;
    private int _M;
    private int _D;
    private int _h;
    private int _m;
    private int _s;
    private BigDecimal _fs;
    private static final GDate[] _compDate = new GDate[]{new GDate(1696, 9, 1, 0, 0, 0, null, 0, 0, 0), new GDate(1697, 2, 1, 0, 0, 0, null, 0, 0, 0), new GDate(1903, 3, 1, 0, 0, 0, null, 0, 0, 0), new GDate(1903, 7, 1, 0, 0, 0, null, 0, 0, 0)};

    public GDurationBuilder() {
        this._sign = 1;
        this._fs = GDate._zero;
    }

    public GDurationBuilder(String string) {
        this(new GDuration(string));
    }

    public GDurationBuilder(int n, int n2, int n3, int n4, int n5, int n6, int n7, BigDecimal bigDecimal) {
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException();
        }
        this._sign = n;
        this._CY = n2;
        this._M = n3;
        this._D = n4;
        this._h = n5;
        this._m = n6;
        this._s = n7;
        this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
    }

    public GDurationBuilder(GDurationSpecification gDurationSpecification) {
        this._sign = gDurationSpecification.getSign();
        this._CY = gDurationSpecification.getYear();
        this._M = gDurationSpecification.getMonth();
        this._D = gDurationSpecification.getDay();
        this._h = gDurationSpecification.getHour();
        this._m = gDurationSpecification.getMinute();
        this._s = gDurationSpecification.getSecond();
        this._fs = gDurationSpecification.getFraction();
    }

    public Object clone() {
        return new GDurationBuilder(this);
    }

    public GDuration toGDuration() {
        return new GDuration(this);
    }

    public void addGDuration(GDurationSpecification gDurationSpecification) {
        int n = this._sign * gDurationSpecification.getSign();
        this._add(gDurationSpecification, n);
    }

    public void subtractGDuration(GDurationSpecification gDurationSpecification) {
        int n = -this._sign * gDurationSpecification.getSign();
        this._add(gDurationSpecification, n);
    }

    private void _add(GDurationSpecification gDurationSpecification, int n) {
        this._CY += n * gDurationSpecification.getYear();
        this._M += n * gDurationSpecification.getMonth();
        this._D += n * gDurationSpecification.getDay();
        this._h += n * gDurationSpecification.getHour();
        this._m += n * gDurationSpecification.getMinute();
        this._s += n * gDurationSpecification.getSecond();
        if (gDurationSpecification.getFraction().signum() == 0) {
            return;
        }
        this._fs = this._fs.signum() == 0 && n == 1 ? gDurationSpecification.getFraction() : (n > 0 ? this._fs.add(gDurationSpecification.getFraction()) : this._fs.subtract(gDurationSpecification.getFraction()));
    }

    public final void setSign(int n) {
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException();
        }
        this._sign = n;
    }

    public void setYear(int n) {
        this._CY = n;
    }

    public void setMonth(int n) {
        this._M = n;
    }

    public void setDay(int n) {
        this._D = n;
    }

    public void setHour(int n) {
        this._h = n;
    }

    public void setMinute(int n) {
        this._m = n;
    }

    public void setSecond(int n) {
        this._s = n;
    }

    public void setFraction(BigDecimal bigDecimal) {
        this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
    }

    @Override
    public final boolean isImmutable() {
        return true;
    }

    @Override
    public final int getSign() {
        return this._sign;
    }

    @Override
    public final int getYear() {
        return this._CY;
    }

    @Override
    public final int getMonth() {
        return this._M;
    }

    @Override
    public final int getDay() {
        return this._D;
    }

    @Override
    public final int getHour() {
        return this._h;
    }

    @Override
    public final int getMinute() {
        return this._m;
    }

    @Override
    public final int getSecond() {
        return this._s;
    }

    @Override
    public BigDecimal getFraction() {
        return this._fs;
    }

    @Override
    public boolean isValid() {
        return GDurationBuilder.isValidDuration(this);
    }

    public void normalize() {
        this._normalizeImpl(true);
    }

    private static final long _fQuotient(long l, int n) {
        if (l < 0L == n < 0) {
            return l / (long)n;
        }
        return -(((long)n - l - 1L) / (long)n);
    }

    private static final int _mod(long l, int n, long l2) {
        return (int)(l - l2 * (long)n);
    }

    private void _normalizeImpl(boolean bl) {
        long l;
        long l2;
        if (this._M < 0 || this._M > 11) {
            l2 = this._M;
            l = GDurationBuilder._fQuotient(l2, 12);
            this._M = GDurationBuilder._mod(l2, 12, l);
            this._CY = (int)((long)this._CY + l);
        }
        l = 0L;
        if (this._fs != null && (this._fs.signum() < 0 || this._fs.compareTo(GDate._one) >= 0)) {
            BigDecimal bigDecimal = this._fs.setScale(0, 3);
            this._fs = this._fs.subtract(bigDecimal);
            l = bigDecimal.intValue();
        }
        if (l != 0L || this._s < 0 || this._s > 59 || this._m < 0 || this._m > 50 || this._h < 0 || this._h > 23) {
            l2 = (long)this._s + l;
            l = GDurationBuilder._fQuotient(l2, 60);
            this._s = GDurationBuilder._mod(l2, 60, l);
            l2 = (long)this._m + l;
            l = GDurationBuilder._fQuotient(l2, 60);
            this._m = GDurationBuilder._mod(l2, 60, l);
            l2 = (long)this._h + l;
            l = GDurationBuilder._fQuotient(l2, 24);
            this._h = GDurationBuilder._mod(l2, 24, l);
            this._D = (int)((long)this._D + l);
        }
        if (this._CY == 0 && this._M == 0 && this._D == 0 && this._h == 0 && this._m == 0 && this._s == 0 && (this._fs == null || this._fs.signum() == 0)) {
            this._sign = 1;
        }
        if (bl && (this._D < 0 || this._CY < 0)) {
            int n;
            int n2 = n = this._D <= 0 && (this._CY < 0 || this._CY == 0 && this._M == 0) ? -this._sign : this._getTotalSignSlowly();
            if (n == 2) {
                int n3 = n = this._CY < 0 ? -this._sign : this._sign;
            }
            if (n == 0) {
                n = 1;
            }
            if (n != this._sign) {
                this._sign = n;
                this._CY = -this._CY;
                this._M = -this._M;
                this._D = -this._D;
                this._h = -this._h;
                this._m = -this._m;
                this._s = -this._s;
                if (this._fs != null) {
                    this._fs = this._fs.negate();
                }
            }
            this._normalizeImpl(false);
        }
    }

    static boolean isValidDuration(GDurationSpecification gDurationSpecification) {
        if (gDurationSpecification.getSign() != 1 && gDurationSpecification.getSign() != -1) {
            return false;
        }
        return gDurationSpecification.getYear() >= 0 && gDurationSpecification.getMonth() >= 0 && gDurationSpecification.getDay() >= 0 && gDurationSpecification.getHour() >= 0 && gDurationSpecification.getMinute() >= 0 && gDurationSpecification.getSecond() >= 0 && gDurationSpecification.getFraction().signum() >= 0;
    }

    @Override
    public final int compareToGDuration(GDurationSpecification gDurationSpecification) {
        return GDurationBuilder.compareDurations(this, gDurationSpecification);
    }

    public String toString() {
        return GDurationBuilder.formatDuration(this);
    }

    static int compareDurations(GDurationSpecification gDurationSpecification, GDurationSpecification gDurationSpecification2) {
        if (gDurationSpecification.getFraction().signum() == 0 && gDurationSpecification2.getFraction().signum() == 0) {
            int n = gDurationSpecification.getSign();
            int n2 = gDurationSpecification2.getSign();
            long l = (long)n * ((long)gDurationSpecification.getYear() * 12L + (long)gDurationSpecification.getMonth());
            long l2 = (long)n2 * ((long)gDurationSpecification2.getYear() * 12L + (long)gDurationSpecification2.getMonth());
            long l3 = (long)n * ((((long)gDurationSpecification.getDay() * 24L + (long)gDurationSpecification.getHour()) * 60L + (long)gDurationSpecification.getMinute()) * 60L + (long)gDurationSpecification.getSecond());
            long l4 = (long)n2 * ((((long)gDurationSpecification2.getDay() * 24L + (long)gDurationSpecification2.getHour()) * 60L + (long)gDurationSpecification2.getMinute()) * 60L + (long)gDurationSpecification2.getSecond());
            if (l == l2) {
                if (l3 == l4) {
                    return 0;
                }
                if (l3 < l4) {
                    return -1;
                }
                if (l3 > l4) {
                    return 1;
                }
            }
            if (l < l2 && l3 - l4 < 2419200L) {
                return -1;
            }
            if (l > l2 && l4 - l3 < 2419200L) {
                return 1;
            }
        }
        GDurationBuilder gDurationBuilder = new GDurationBuilder(gDurationSpecification);
        gDurationBuilder.subtractGDuration(gDurationSpecification2);
        return gDurationBuilder._getTotalSignSlowly();
    }

    private int _getTotalSignSlowly() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        GDateBuilder gDateBuilder = new GDateBuilder();
        block5: for (int i = 0; i < _compDate.length; ++i) {
            gDateBuilder.setGDate(_compDate[i]);
            gDateBuilder.addGDuration(this);
            switch (gDateBuilder.compareToGDate(_compDate[i])) {
                case -1: {
                    ++n2;
                    continue block5;
                }
                case 0: {
                    ++n3;
                    continue block5;
                }
                case 1: {
                    ++n;
                }
            }
        }
        if (n == _compDate.length) {
            return 1;
        }
        if (n2 == _compDate.length) {
            return -1;
        }
        if (n3 == _compDate.length) {
            return 0;
        }
        return 2;
    }

    static String formatDuration(GDurationSpecification gDurationSpecification) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (gDurationSpecification.getSign() < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (gDurationSpecification.getYear() != 0) {
            stringBuffer.append(gDurationSpecification.getYear());
            stringBuffer.append('Y');
        }
        if (gDurationSpecification.getMonth() != 0) {
            stringBuffer.append(gDurationSpecification.getMonth());
            stringBuffer.append('M');
        }
        if (gDurationSpecification.getDay() != 0) {
            stringBuffer.append(gDurationSpecification.getDay());
            stringBuffer.append('D');
        }
        if (gDurationSpecification.getHour() != 0 || gDurationSpecification.getMinute() != 0 || gDurationSpecification.getSecond() != 0 || gDurationSpecification.getFraction().signum() != 0) {
            stringBuffer.append('T');
        }
        if (gDurationSpecification.getHour() != 0) {
            stringBuffer.append(gDurationSpecification.getHour());
            stringBuffer.append('H');
        }
        if (gDurationSpecification.getMinute() != 0) {
            stringBuffer.append(gDurationSpecification.getMinute());
            stringBuffer.append('M');
        }
        if (gDurationSpecification.getFraction().signum() != 0) {
            BigDecimal bigDecimal = gDurationSpecification.getFraction();
            if (gDurationSpecification.getSecond() != 0) {
                bigDecimal = bigDecimal.add(BigDecimal.valueOf(gDurationSpecification.getSecond()));
            }
            stringBuffer.append(GDurationBuilder.stripTrailingZeros(GDurationBuilder.toPlainString(bigDecimal)));
            stringBuffer.append('S');
        } else if (gDurationSpecification.getSecond() != 0) {
            stringBuffer.append(gDurationSpecification.getSecond());
            stringBuffer.append('S');
        } else if (stringBuffer.length() <= 2) {
            stringBuffer.append("T0S");
        }
        return stringBuffer.toString();
    }

    public static String toPlainString(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n = bigDecimal.scale();
        String string = bigInteger.toString();
        if (n == 0) {
            return string;
        }
        boolean bl = string.charAt(0) == '-';
        int n2 = string.length() - n - (bl ? 1 : 0);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2 + (n2 <= 0 ? -n2 + 1 : 0));
        if (n2 <= 0) {
            if (bl) {
                stringBuffer.append('-');
            }
            stringBuffer.append('0').append('.');
            while (n2 < 0) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string.substring(bl ? 1 : 0));
        } else if (n2 < string.length()) {
            stringBuffer.append(string);
            stringBuffer.insert(n2 + (bl ? 1 : 0), '.');
        } else {
            stringBuffer.append(string);
            if (!bigInteger.equals(BigInteger.ZERO)) {
                for (int i = string.length(); i < n2; ++i) {
                    stringBuffer.append('0');
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String stripTrailingZeros(String string) {
        int n;
        boolean bl = false;
        int n2 = n = string.length() - 1;
        while (n >= 0 && string.charAt(n) == '0') {
            --n;
            --n2;
        }
        while (n >= 0) {
            if (string.charAt(n) == 'E') {
                return string;
            }
            if (string.charAt(n) == '.') {
                bl = true;
                break;
            }
            --n;
        }
        return bl ? string.substring(0, n2 + 1) : string;
    }
}

