/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.TypeMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;

public class SimpleType
extends SchemaType
implements Serializable {
    protected Element element;
    private Element restrictionElement;
    private SchemaType baseType;
    private List<SchemaProperty> properties = new ArrayList<SchemaProperty>();
    private SchemaAnnotation annotation;

    protected static SchemaType build(Element element, SchemaDocument schemaDocument) throws Exception {
        SimpleType simpleType = new SimpleType(element, schemaDocument);
        simpleType.parse();
        return simpleType;
    }

    protected SimpleType(String string, SchemaType schemaType, SchemaDocument schemaDocument) throws Exception {
        if (schemaType == null || schemaType.getName() == null) {
            throw new SchemaException("missing or invalid base type for simple type [" + string + "]");
        }
        this.element = new Element("simpleType", schemaDocument.getNamespace());
        this.element.setAttribute("name", string);
        this.schemaDocument = schemaDocument;
        this.restrictionElement = new Element("restriction", schemaDocument.getNamespace());
        this.element.addContent((Content)this.restrictionElement);
        this.setBaseType(schemaType);
    }

    protected SimpleType(Element element, SchemaDocument schemaDocument) {
        this.element = element;
        this.schemaDocument = schemaDocument;
    }

    @Override
    protected void parse() throws Exception {
        for (Element element : this.element.getChildren()) {
            if (element.getName().equals("restriction")) {
                this.parseRestriction(element);
                continue;
            }
            if (element.getName().equals("annotation")) {
                this.annotation = new SchemaAnnotation(element);
                continue;
            }
            if (element.getName().equals("list")) {
                throw new SchemaException("simple type lists are not implemented in namespace [" + this.schemaDocument.getTargetNamespace() + "]");
            }
            if (element.getName().equals("union")) {
                throw new SchemaException("simple type unions are not implemented in namespace [" + this.schemaDocument.getTargetNamespace() + "]");
            }
            throw new SchemaException("unknown schema element [" + element.getName() + "] under [" + this.element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void parseRestriction(Element element) throws Exception {
        QName qName = this.schemaDocument.buildName(element.getAttributeValue("base"), element.getAdditionalNamespaces());
        this.baseType = this.schemaDocument.getSchemaTypeSystem().lookupType(qName);
        if (this.baseType == null) {
            throw new SchemaException("could not find type for [" + this.getName() + "] in namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
        this.restrictionElement = element;
    }

    private void setBaseType(SchemaType schemaType) throws Exception {
        this.baseType = schemaType;
        this.restrictionElement.setAttribute("base", this.schemaDocument.getReferenceName(this.baseType.getName()));
    }

    @Override
    public QName getName() {
        if (this.element.getAttributeValue("name") == null) {
            return null;
        }
        return new QName(this.schemaDocument.getTargetNamespace(), this.element.getAttributeValue("name"));
    }

    @Override
    public SchemaType getBaseType() {
        return this.baseType;
    }

    @Override
    public Vector<String> getEnumerations() {
        Vector<String> vector = new Vector<String>();
        for (Element element : this.restrictionElement.getChildren("enumeration", this.schemaDocument.getNamespace())) {
            if (element.getAttributeValue("value") == null) continue;
            vector.add(element.getAttributeValue("value"));
        }
        return vector;
    }

    public void addEnumeration(Object object) {
        Element element = new Element("enumeration", this.schemaDocument.getNamespace());
        element.setAttribute("value", String.valueOf(object));
        this.restrictionElement.addContent((Content)element);
    }

    @Override
    public List<SchemaProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Class getJavaClass() {
        return TypeMap.getJavaClass(this.getName().getLocalPart());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isAny() {
        return false;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public SchemaAnnotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SchemaAnnotation(this.element.getNamespace());
            this.element.addContent((Content)this.annotation.getElement());
        }
        return this.annotation;
    }

    @Override
    public boolean isComplex() {
        return false;
    }
}

