/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaAttribute;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class ComplexType
extends SchemaType
implements Serializable {
    protected Element element;
    private SchemaType baseType;
    private boolean any = false;
    private SchemaAnnotation annotation;
    private final Map<String, SchemaElement> elementProperties = new HashMap<String, SchemaElement>();
    private final Map<String, SchemaAttribute> attributeProperties = new HashMap<String, SchemaAttribute>();
    private final List<SchemaProperty> properties = new ArrayList<SchemaProperty>();
    private Element propertyParentElement;
    private Element sequenceElement;

    protected static SchemaType build(Element element, SchemaDocument schemaDocument) throws Exception {
        ComplexType complexType = new ComplexType(element, schemaDocument);
        complexType.parse();
        return complexType;
    }

    protected ComplexType(SchemaDocument schemaDocument) {
        this.element = new Element("complexType", schemaDocument.getNamespace());
        this.schemaDocument = schemaDocument;
        this.propertyParentElement = this.element;
        this.sequenceElement = new Element("sequence", schemaDocument.getNamespace());
        this.element.addContent((Content)this.sequenceElement);
    }

    protected ComplexType(String string, SchemaType schemaType, boolean bl, SchemaDocument schemaDocument) throws Exception {
        this.element = new Element("complexType", schemaDocument.getNamespace());
        this.element.setAttribute("name", string);
        this.schemaDocument = schemaDocument;
        this.baseType = schemaType;
        this.sequenceElement = new Element("sequence", schemaDocument.getNamespace());
        if (schemaType == null) {
            this.propertyParentElement = this.element;
        } else {
            Element element = new Element("complexContent", schemaDocument.getNamespace());
            this.element.addContent((Content)element);
            this.propertyParentElement = new Element("extension", schemaDocument.getNamespace());
            this.propertyParentElement.setAttribute("base", schemaDocument.getReferenceName(schemaType.getName()));
            element.addContent((Content)this.propertyParentElement);
        }
        this.propertyParentElement.addContent((Content)this.sequenceElement);
        this.setAbstract(bl);
    }

    protected ComplexType(Element element, SchemaDocument schemaDocument) {
        this.propertyParentElement = this.element = element;
        this.schemaDocument = schemaDocument;
    }

    @Override
    protected void parse() throws Exception {
        if (this.element != null) {
            for (Element element : this.element.getChildren()) {
                if (element.getName().equals("complexContent")) {
                    this.parseComplexContent(element);
                    continue;
                }
                if (element.getName().equals("simpleContent")) {
                    this.parseSimpleContent(element);
                    continue;
                }
                if (element.getName().equals("sequence")) {
                    this.parseSequence(element);
                    continue;
                }
                if (element.getName().equals("attribute")) {
                    this.parseAttribute(element);
                    continue;
                }
                if (element.getName().equals("annotation")) {
                    this.annotation = new SchemaAnnotation(element);
                    continue;
                }
                if (element.getName().equals("anyAttribute")) continue;
                throw new SchemaException("unknown schema element [" + element.getName() + "] under [" + this.element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
            }
        }
    }

    private void parseSimpleContent(Element element) throws Exception {
        for (Element element2 : element.getChildren()) {
            if (element2.getName().equals("extension")) {
                this.parseExtension(element2);
                continue;
            }
            throw new SchemaException("unknown schema element [" + element2.getName() + "] under [" + element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void parseComplexContent(Element element) throws Exception {
        for (Element element2 : element.getChildren()) {
            if (element2.getName().equals("extension")) {
                this.parseExtension(element2);
                continue;
            }
            throw new SchemaException("unknown schema element [" + element2.getName() + "] under [" + element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void parseExtension(Element element) throws Exception {
        this.propertyParentElement = element;
        this.setBaseType(element);
        for (Element element2 : element.getChildren()) {
            if (element2.getName().equals("sequence")) {
                this.parseSequence(element2);
                continue;
            }
            if (element2.getName().equals("attribute")) {
                this.parseAttribute(element2);
                continue;
            }
            throw new SchemaException("unknown schema element [" + element2.getName() + "] under [" + element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void setBaseType(Element element) throws Exception {
        QName qName = this.schemaDocument.buildName(element.getAttributeValue("base"), element.getAdditionalNamespaces());
        this.baseType = this.schemaDocument.getSchemaTypeSystem().lookupType(qName);
        if (this.baseType == null) {
            System.err.println("could not find type for [" + qName + "] in namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void parseSequence(Element element) throws Exception {
        this.sequenceElement = element;
        for (Element element2 : element.getChildren()) {
            if (element2.getName().equals("element")) {
                this.parseElement(element2);
                continue;
            }
            if (element2.getName().equals("any")) {
                this.any = true;
                continue;
            }
            throw new SchemaException("unknown schema element [" + element2.getName() + "] under [" + element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    private void parseAttribute(Element element) throws Exception {
        SchemaAttribute schemaAttribute = SchemaAttribute.parse(element, this.schemaDocument);
        this.putAttribute(schemaAttribute, schemaAttribute.element);
    }

    private void parseElement(Element element) throws Exception {
        SchemaElement schemaElement = SchemaElement.parse(element, this.schemaDocument);
        if (schemaElement != null) {
            this.putElement(schemaElement, schemaElement.element);
        }
    }

    private void putElement(SchemaElement schemaElement, Element element) {
        this.elementProperties.put(schemaElement.getName().getLocalPart(), schemaElement);
        this.properties.add(schemaElement);
    }

    private void putAttribute(SchemaAttribute schemaAttribute, Element element) {
        this.attributeProperties.put(schemaAttribute.getName().getLocalPart(), schemaAttribute);
        this.properties.add(schemaAttribute);
    }

    @Override
    public QName getName() {
        if (this.element.getAttributeValue("name") == null) {
            return null;
        }
        return new QName(this.schemaDocument.getTargetNamespace(), this.element.getAttributeValue("name"));
    }

    @Override
    public SchemaType getBaseType() {
        return this.baseType;
    }

    @Override
    public List<SchemaProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Class getJavaClass() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        if (this.element.getAttribute("abstract") == null) {
            return false;
        }
        return Boolean.parseBoolean(this.element.getAttributeValue("abstract"));
    }

    public void setAbstract(boolean bl) {
        if (!bl) {
            this.element.removeAttribute("abstract");
        } else {
            this.element.setAttribute("abstract", Boolean.valueOf(bl).toString());
        }
    }

    @Override
    public boolean isAny() {
        return this.any;
    }

    public void setAny(boolean bl) {
        if (bl) {
            this.clear();
            Element element = new Element("any", this.schemaDocument.getNamespace());
            this.sequenceElement.addContent((Content)element);
        } else {
            this.sequenceElement.removeChildren("any", this.schemaDocument.getNamespace());
        }
        this.any = bl;
    }

    public void addElement(SchemaElement schemaElement) throws Exception {
        if (this.any) {
            throw new SchemaException("cannot add elements to type any [" + this.getName() + "]");
        }
        if (schemaElement.isGlobal()) {
            if (!this.elementProperties.containsKey(schemaElement.getName().getLocalPart())) {
                String string = this.schemaDocument.getReferenceName(schemaElement.getName());
                Element element = new Element("element", this.schemaDocument.getNamespace());
                this.sequenceElement.addContent((Content)element);
                element.setAttribute("ref", string);
                this.putElement(schemaElement, element);
            }
        } else {
            throw new SchemaException("cannot reference a non global element [" + schemaElement.getName() + "] in type [" + this.getName() + "]");
        }
    }

    public SchemaElement addElement(String string) throws Exception {
        return this.addElement(string, GenericTypes.STRING.getType());
    }

    public SchemaElement addElement(String string, SchemaType schemaType) throws Exception {
        if (this.any) {
            throw new SchemaException("cannot add elements to type any [" + this.getName() + "]");
        }
        if (!this.elementProperties.containsKey(string)) {
            SchemaElement schemaElement = SchemaElement.newInstance(string, schemaType, this.schemaDocument);
            this.sequenceElement.addContent((Content)schemaElement.element);
            this.putElement(schemaElement, schemaElement.element);
            return schemaElement;
        }
        throw new SchemaException("type [" + this.getName() + "] already contains element named [" + string + "]");
    }

    public boolean removeElement(String string) {
        return this.removeElement(this.elementProperties.get(string));
    }

    public boolean removeElement(SchemaElement schemaElement) {
        if (schemaElement != null) {
            this.elementProperties.remove(schemaElement.getName().getLocalPart());
            this.properties.remove(schemaElement);
            Element element = this.getSchemaElementElement(schemaElement.getName().getLocalPart());
            boolean bl = this.sequenceElement.removeContent((Content)element);
            return bl;
        }
        return false;
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(this.attributeProperties.get(string));
    }

    public boolean removeAttribute(SchemaAttribute schemaAttribute) {
        if (schemaAttribute != null) {
            this.attributeProperties.remove(schemaAttribute.getName().getLocalPart());
            this.properties.remove(schemaAttribute);
            Element element = this.getSchemaAttributeElement(schemaAttribute.getName().getLocalPart());
            boolean bl = this.propertyParentElement.removeContent((Content)element);
            return bl;
        }
        return false;
    }

    public void addAttribute(SchemaAttribute schemaAttribute) throws Exception {
        if (this.any) {
            throw new SchemaException("cannot add attributes to type any [" + this.getName() + "]");
        }
        if (schemaAttribute.isGlobal()) {
            if (!this.attributeProperties.containsKey(schemaAttribute.getName().getLocalPart())) {
                String string = this.schemaDocument.getReferenceName(schemaAttribute.getName());
                Element element = new Element("attribute", this.schemaDocument.getNamespace());
                this.propertyParentElement.addContent((Content)element);
                element.setAttribute("ref", string);
                this.putAttribute(schemaAttribute, element);
            }
        } else {
            throw new SchemaException("cannot reference a non global attribute [" + schemaAttribute.getName() + "] in type [" + this.getName() + "]");
        }
    }

    public SchemaAttribute addAttribute(String string) throws Exception {
        if (this.any) {
            throw new SchemaException("cannot add attributes to type any [" + this.getName() + "]");
        }
        if (!this.attributeProperties.containsKey(string)) {
            SchemaAttribute schemaAttribute = SchemaAttribute.newInstance(string, this.schemaDocument);
            this.propertyParentElement.addContent((Content)schemaAttribute.element);
            this.putAttribute(schemaAttribute, schemaAttribute.element);
            return schemaAttribute;
        }
        throw new SchemaException("type [" + this.getName().toString() + "] already contains attribute named [" + string + "]");
    }

    private void clear() {
        this.elementProperties.clear();
        this.attributeProperties.clear();
        this.properties.clear();
        this.sequenceElement.removeContent();
    }

    @Override
    public String toString() {
        try {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(this.element, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return String.valueOf(this.getName());
        }
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Vector<String> getEnumerations() {
        return null;
    }

    @Override
    public SchemaAnnotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SchemaAnnotation(this.element.getNamespace());
            this.element.addContent((Content)this.annotation.getElement());
        }
        return this.annotation;
    }

    private Element getSchemaAttributeElement(String string) {
        for (Element element : this.propertyParentElement.getChildren("attribute")) {
            if (!element.getAttributeValue("name").equals(string)) continue;
            return element;
        }
        return null;
    }

    private Element getSchemaElementElement(String string) {
        for (Element element : this.propertyParentElement.getChildren("element")) {
            if (!element.getAttributeValue("name").equals(string)) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean isComplex() {
        return true;
    }
}

