/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import commvault.cte.common.BareBonesBrowserLaunch;
import commvault.cte.common.BrowserLauncher;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;

public class DesktopBrowserLauncher {
    public static void openURL(String string) throws IOException {
        if (DesktopBrowserLauncher.isMacOS()) {
            System.out.println("For MAC OS, trying to launch using BareBonesBrowserLaunch");
            try {
                BareBonesBrowserLaunch.openURL(string);
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Failed to launch using BareBonesBrowserLaunch");
                throwable.printStackTrace();
            }
        }
        System.out.println("Trying to launch using launchUsingDesktopAPIWithReflection()");
        boolean bl = DesktopBrowserLauncher.launchUsingDesktopAPIWithReflection(string);
        if (!bl) {
            try {
                System.out.println("Trying to launch using BrowserLauncher");
                BrowserLauncher.openURL(string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.err.println("Failed to launch using BrowserLauncher.");
                System.out.println("Trying to launch using BareBonesBrowserLaunch");
                BareBonesBrowserLaunch.openURL(string);
            }
        }
    }

    private static boolean isMacOS() {
        String string = System.getProperty("os.name");
        System.out.println("OS=" + string);
        return string.toLowerCase().startsWith("mac");
    }

    private static boolean launchUsingDesktopAPIWithReflection(String string) {
        try {
            Method method = Class.forName("java.awt.Desktop2").getMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            object.getClass().getMethod("browse", URI.class).invoke(object, new URI(string));
        }
        catch (Throwable throwable) {
            System.err.println("Failed to launch using launchUsingDesktopAPIWithReflection");
            return false;
        }
        return true;
    }
}

