/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm.db;

import commvault.cte.cm.ColumnType;
import commvault.cte.cm.db.DBConnection;
import commvault.msgs.CM.Column;
import java.sql.PreparedStatement;

public abstract class DBBase
extends DBConnection {
    private int parameterIndex = 1;

    protected DBBase() throws Exception {
    }

    public abstract Object execute() throws Exception;

    public PreparedStatement getStatement() {
        return (PreparedStatement)this.m_statement;
    }

    public void addParameter(Column column) throws Exception {
        ColumnType columnType = ColumnType.fromInt(column.getColumnType());
        this.addParameter(columnType, column.getRowValue());
    }

    private void addParameter(ColumnType columnType, String string) throws Exception {
        switch (columnType) {
            case STRING: 
            case MULTISTRING: {
                this.getStatement().setString(this.parameterIndex, string);
                break;
            }
            case INTEGER: {
                if (string.length() > 0) {
                    this.getStatement().setInt(this.parameterIndex, Integer.parseInt(string));
                    break;
                }
                this.getStatement().setObject(this.parameterIndex, null);
                break;
            }
            case FLOAT: {
                if (string.length() > 0) {
                    this.getStatement().setFloat(this.parameterIndex, Float.parseFloat(string));
                    break;
                }
                this.getStatement().setObject(this.parameterIndex, null);
                break;
            }
            default: {
                this.getStatement().setString(this.parameterIndex, string);
            }
        }
        ++this.parameterIndex;
    }
}

