/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.db.DBSelect;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;

public class AttachmentStream
extends InputStream {
    private DBSelect query;
    private InputStream binaryStream;

    protected static AttachmentStream open(DBSelect dBSelect) throws Exception {
        AttachmentStream attachmentStream = new AttachmentStream();
        attachmentStream.query = dBSelect;
        ResultSet resultSet = dBSelect.execute();
        if (resultSet.next()) {
            attachmentStream.binaryStream = resultSet.getBinaryStream("Attachment");
            return attachmentStream;
        }
        dBSelect.close();
        return null;
    }

    private AttachmentStream() throws Exception {
    }

    @Override
    public int available() throws IOException {
        return this.binaryStream.available();
    }

    @Override
    public synchronized void mark(int n) {
        this.binaryStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.binaryStream.markSupported();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.binaryStream.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.binaryStream.read(byArray);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.binaryStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.binaryStream.skip(l);
    }

    @Override
    public int read() throws IOException {
        return this.binaryStream.read();
    }

    @Override
    public void close() throws IOException {
        this.query.close();
        this.binaryStream.close();
    }
}

