/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert.model;

import commvault.cte.alert.model.ASO;
import commvault.cte.alert.model.AlertCriteria;
import commvault.cte.alert.model.AlertEntityLoader;
import commvault.cte.alert.model.AlertListItem;
import commvault.cte.alert.model.AlertNotifMsg;
import commvault.cte.alert.model.AlertType;
import commvault.cte.alert.model.ICriteria;
import commvault.cte.alert.model.NTAction;
import commvault.cte.alert.model.ReportingCriteria;
import commvault.cte.alert.model.RssFeeds;
import commvault.cte.alert.model.RunCommand;
import commvault.cte.alert.model.SaveAlertToDisk;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityImpl;
import commvault.cte.net.IdIdNameItem;
import commvault.cte.net.IdNameItem;
import commvault.cte.util.Logger;
import commvault.msgs.App.SecurityAssociationForEntityList;
import commvault.msgs.CvEntities.GenericEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public class Alert {
    private AlertListItem alertDetails;
    private List<AlertUser> userList;
    private List userGroupList;
    private RunCommand[] runCommands = new RunCommand[2];
    private List criteria;
    private List notifMsgs;
    private ASO alertServerObject;
    private ReportingCriteria[] repCriterias = new ReportingCriteria[2];
    private int modificationBit;
    private Entity rootEntity;
    private boolean jobBasedAlert;
    private String jobBasedEnity = null;
    private List externalGroupList = null;
    private List<IdIdNameItem> nonGalaxyUserList = null;
    private List<IdIdNameItem> nonGalaxyUserListCc = null;
    private List<IdIdNameItem> nonGalaxyUserListBcc = null;
    private int remoteCmdAssoc;
    private IdNameItem locale;
    private String eventCriteria;
    private String customCriteria;
    private int alertSeverity;
    private int escalationSeverity;
    private int eventParam;
    private String alertTokenRuleGroupXML;
    private String tokenRulesSummary;
    private List<IdIdNameItem> userListTo;
    private List<IdIdNameItem> userListCc;
    private List<IdIdNameItem> userGroupListCc;
    private List<IdIdNameItem> externalUserGroupListCc;
    private List<IdIdNameItem> userListBcc;
    private List<IdIdNameItem> userGroupListBcc;
    private List<IdIdNameItem> externalUserGroupListBcc;
    private String senderDisplayName;
    private String senderEmailId;
    private boolean isCustomRecipientColumnSupported;
    private HashMap<Integer, List> actionAlertTokenListMap = new HashMap();
    private SecurityAssociationForEntityList securityAssociations = null;
    private int minJobCountForJobAnomaly;
    private List<GenericEntity> appTypeFilter;
    private List<Integer> allSelectedAppTypes;
    private List<GenericEntity> entitList;

    public List<IdIdNameItem> getUserListTo() {
        return this.userListTo;
    }

    public List<IdIdNameItem> getUserListCc() {
        return this.userListCc;
    }

    public List<IdIdNameItem> getUserListBcc() {
        return this.userListBcc;
    }

    public List<IdIdNameItem> getUserGroupListCc() {
        return this.userGroupListCc;
    }

    public List<IdIdNameItem> getUserGroupListBcc() {
        return this.userGroupListBcc;
    }

    public List<IdIdNameItem> getExternalUserGroupListCc() {
        return this.externalUserGroupListCc;
    }

    public List<IdIdNameItem> getExternalUserGroupListBcc() {
        return this.externalUserGroupListBcc;
    }

    public int getMinJobCountForJobAnomaly() {
        return this.minJobCountForJobAnomaly;
    }

    public void setUserListTo(List<IdIdNameItem> list) {
        this.userListTo = list;
    }

    public void setUserListCc(List<IdIdNameItem> list) {
        this.userListCc = list;
    }

    public void setUserListBcc(List<IdIdNameItem> list) {
        this.userListBcc = list;
    }

    public void setUserGroupListCc(List<IdIdNameItem> list) {
        this.userGroupListCc = list;
    }

    public void setUserGroupListBcc(List<IdIdNameItem> list) {
        this.userGroupListBcc = list;
    }

    public void setExternalUserGroupListCc(List<IdIdNameItem> list) {
        this.externalUserGroupListCc = list;
    }

    public void setExternalUserGroupListBcc(List<IdIdNameItem> list) {
        this.externalUserGroupListBcc = list;
    }

    public void setMinJobCountForJobAnomaly(int n) {
        this.minJobCountForJobAnomaly = n;
    }

    public SecurityAssociationForEntityList getSecurityAssociations() {
        if (this.securityAssociations == null) {
            this.securityAssociations = new SecurityAssociationForEntityList();
        }
        return this.securityAssociations;
    }

    public void setSecurityAssociations(SecurityAssociationForEntityList securityAssociationForEntityList) {
        this.securityAssociations = securityAssociationForEntityList;
    }

    public String getAlertTokenRuleGroupXML() {
        return this.alertTokenRuleGroupXML;
    }

    public boolean getIsCustomRecipientColumnSupported() {
        return this.isCustomRecipientColumnSupported;
    }

    public void setIsCustomRecipientColumnSupported(boolean bl) {
        this.isCustomRecipientColumnSupported = bl;
    }

    public void setAlertTokenRuleGroupXML(String string) {
        this.alertTokenRuleGroupXML = string;
    }

    public String getTokenRulesSummary() {
        return this.tokenRulesSummary;
    }

    public void setTokenRulesSummary(String string) {
        this.tokenRulesSummary = string;
    }

    public void setAllSelectedAppTypes(List<Integer> list) {
        this.allSelectedAppTypes = list;
    }

    public List<Integer> getAllSelectedAppTypes() {
        return this.allSelectedAppTypes;
    }

    public int getAlertSeverity() {
        return this.alertSeverity;
    }

    public void setAlertSeverity(int n) {
        this.alertSeverity = n;
    }

    public int getEscalationSeverity() {
        return this.escalationSeverity;
    }

    public void setEscalationSeverity(int n) {
        this.escalationSeverity = n;
    }

    public List<GenericEntity> getAppTypeFilter() {
        return this.appTypeFilter;
    }

    public void setAppTypeFilter(List<GenericEntity> list) {
        this.appTypeFilter = list;
    }

    public String getEventCriteria() {
        return this.eventCriteria;
    }

    public void setEventCriteria(String string) {
        this.eventCriteria = string;
    }

    public String getCustomCriteria() {
        return this.customCriteria;
    }

    public void setCustomCriteria(String string) {
        this.customCriteria = string;
    }

    public int getEventParams() {
        return this.eventParam;
    }

    public void setEventParams(int n) {
        this.eventParam = n;
    }

    public String getSenderEmailId() {
        return this.senderEmailId;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public void setSenderDisplayName(String string) {
        this.senderDisplayName = string;
    }

    public void setSenderEmailId(String string) {
        this.senderEmailId = string;
    }

    public Alert(ASO aSO, IdNameItem idNameItem) {
        this(aSO, null, idNameItem);
    }

    public Alert(ASO aSO, AlertListItem alertListItem) {
        this(aSO, alertListItem, null);
    }

    public Alert(ASO aSO, AlertListItem alertListItem, IdNameItem idNameItem) {
        this.alertDetails = alertListItem;
        if (this.alertDetails == null) {
            this.alertDetails = new AlertListItem();
        }
        if (idNameItem != null) {
            this.alertDetails.setCreator(idNameItem);
            this.alertDetails.setCreatedTime((int)(new Date().getTime() / 1000L));
        }
        this.alertServerObject = aSO;
        this.userList = new ArrayList<AlertUser>();
        this.userGroupList = new ArrayList();
        this.externalGroupList = new ArrayList();
        this.nonGalaxyUserList = new ArrayList<IdIdNameItem>();
        this.nonGalaxyUserListCc = new ArrayList<IdIdNameItem>();
        this.nonGalaxyUserListBcc = new ArrayList<IdIdNameItem>();
        this.userListTo = new ArrayList<IdIdNameItem>();
        this.userListCc = new ArrayList<IdIdNameItem>();
        this.userListBcc = new ArrayList<IdIdNameItem>();
        this.userGroupListCc = new ArrayList<IdIdNameItem>();
        this.userGroupListBcc = new ArrayList<IdIdNameItem>();
        this.externalUserGroupListCc = new ArrayList<IdIdNameItem>();
        this.externalUserGroupListBcc = new ArrayList<IdIdNameItem>();
        this.notifMsgs = new ArrayList();
        this.runCommands[0] = new RunCommand(1);
        this.runCommands[1] = new RunCommand(2);
        this.repCriterias[0] = new ReportingCriteria(1);
        this.repCriterias[1] = new ReportingCriteria(2);
        this.appTypeFilter = new ArrayList<GenericEntity>();
        this.allSelectedAppTypes = new ArrayList<Integer>();
    }

    public Alert(ASO aSO, AlertListItem alertListItem, IdNameItem idNameItem, Alert alert) {
        this.alertDetails = alertListItem;
        if (this.alertDetails == null) {
            this.alertDetails = new AlertListItem();
        }
        this.alertSeverity = alert.getAlertSeverity();
        this.alertServerObject = aSO;
        this.userList = alert.getUserList() != null ? alert.userList : new ArrayList<AlertUser>();
        this.userListTo = alert.getUserListTo() != null ? alert.userListTo : new ArrayList<IdIdNameItem>();
        this.userGroupList = new ArrayList();
        this.externalGroupList = new ArrayList();
        this.nonGalaxyUserList = new ArrayList<IdIdNameItem>();
        this.nonGalaxyUserListCc = new ArrayList<IdIdNameItem>();
        this.nonGalaxyUserListBcc = new ArrayList<IdIdNameItem>();
        this.userListCc = new ArrayList<IdIdNameItem>();
        this.userListBcc = new ArrayList<IdIdNameItem>();
        this.userGroupListCc = new ArrayList<IdIdNameItem>();
        this.userGroupListBcc = new ArrayList<IdIdNameItem>();
        this.externalUserGroupListCc = new ArrayList<IdIdNameItem>();
        this.externalUserGroupListBcc = new ArrayList<IdIdNameItem>();
        this.notifMsgs = new ArrayList();
        this.appTypeFilter = new ArrayList<GenericEntity>();
        this.allSelectedAppTypes = new ArrayList<Integer>();
        this.runCommands[0] = new RunCommand(1);
        this.runCommands[1] = new RunCommand(2);
        this.repCriterias[0] = new ReportingCriteria(1);
        this.repCriterias[1] = new ReportingCriteria(2);
        this.senderEmailId = alert.getSenderEmailId();
        this.senderDisplayName = alert.getSenderDisplayName();
        this.minJobCountForJobAnomaly = alert.getMinJobCountForJobAnomaly();
    }

    private void initialiseCriteria() {
        this.criteria = new ArrayList();
        AlertType alertType = this.getAlertType();
        for (ICriteria iCriteria : alertType.getAvailCriteriaList()) {
            AlertCriteria alertCriteria = new AlertCriteria(iCriteria);
            if (this.alertDetails.getAlertName().getId() <= 0) {
                alertCriteria.setSelected(iCriteria.isDefaultSelection());
            }
            this.criteria.add(alertCriteria);
        }
    }

    public AlertListItem getAlertDetails() {
        return this.alertDetails;
    }

    public void setAlertDetails(AlertListItem alertListItem) {
        this.alertDetails = alertListItem;
    }

    public List<AlertUser> getUserList() {
        return this.userList;
    }

    public void setUserList(List<AlertUser> list) {
        this.userList = list;
    }

    public List getUserGroupList() {
        return this.userGroupList;
    }

    public List getUsersAndGroups(int n) {
        ArrayList<IdIdNameItem> arrayList = new ArrayList<IdIdNameItem>();
        for (AlertUser object : this.userList) {
            IdIdNameItem idIdNameItem = object.getUserItemIfCriteriaMatches(n);
            if (idIdNameItem == null) continue;
            arrayList.add(idIdNameItem);
        }
        for (IdIdNameItem idIdNameItem : this.userGroupList) {
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(new IdIdNameItem(idIdNameItem.getFirstId(), 2, idIdNameItem.getName()));
        }
        for (IdIdNameItem idIdNameItem : this.externalGroupList) {
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(new IdIdNameItem(idIdNameItem.getFirstId(), 4, idIdNameItem.getName()));
        }
        return arrayList;
    }

    public List getNonGalaxyUsers(int n) {
        ArrayList<IdIdNameItem> arrayList = new ArrayList<IdIdNameItem>();
        for (IdIdNameItem idIdNameItem : this.nonGalaxyUserList) {
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(new IdIdNameItem(idIdNameItem.getFirstId(), 5, idIdNameItem.getName()));
        }
        return arrayList;
    }

    public void setUserGroupList(List list) {
        this.userGroupList = list;
    }

    public RunCommand getRunCommand(int n) {
        return this.runCommands[n - 1];
    }

    public List getAvailableAlertCriterias() {
        if (this.criteria == null) {
            this.initialiseCriteria();
        }
        return this.criteria;
    }

    public List<AlertCriteria> getAllCriteria(boolean bl, boolean bl2) {
        ArrayList<AlertCriteria> arrayList = new ArrayList<AlertCriteria>();
        AlertType alertType = this.getAlertType();
        for (ICriteria iCriteria : alertType.getAvailCriteriaList()) {
            AlertCriteria alertCriteria = new AlertCriteria(iCriteria);
            if (bl) {
                alertCriteria.setSelected(bl2);
            }
            arrayList.add(alertCriteria);
        }
        return arrayList;
    }

    public List getCriteria() {
        Iterator iterator = this.getAvailableAlertCriterias().iterator();
        ArrayList<AlertCriteria> arrayList = new ArrayList<AlertCriteria>();
        while (iterator.hasNext()) {
            AlertCriteria alertCriteria = (AlertCriteria)iterator.next();
            if (!alertCriteria.isSelected()) continue;
            arrayList.add(alertCriteria);
        }
        return arrayList;
    }

    public boolean isCriteriaSelected(int n) {
        for (AlertCriteria alertCriteria : this.getAvailableAlertCriterias()) {
            if (!alertCriteria.isSelected() || alertCriteria.getCriteria().getCriterta().getId() != n) continue;
            return true;
        }
        return false;
    }

    public List getNotifMsgs() {
        return this.notifMsgs;
    }

    public List getActionTokenList(int n) {
        if (this.actionAlertTokenListMap.get(n) == null) {
            this.actionAlertTokenListMap.put(n, new ArrayList());
        }
        return this.actionAlertTokenListMap.get(n);
    }

    public void setNotifMsgs(List list) {
        this.notifMsgs = list;
    }

    public AlertType getAlertType() {
        return this.alertServerObject.getAlertType(this.alertDetails.getAlertType().getId(), this.alertDetails.getAlertCategory().getId());
    }

    public ASO getAlertServerObject() {
        return this.alertServerObject;
    }

    public AlertNotifMsg getNotifMsg(boolean bl, int n) {
        if (this.notifMsgs == null) {
            return null;
        }
        for (AlertNotifMsg alertNotifMsg : this.notifMsgs) {
            if (alertNotifMsg.getNotifType() != n || alertNotifMsg.getEsclationLevel() != (bl ? 2 : 1)) continue;
            return alertNotifMsg;
        }
        return null;
    }

    public NTAction getAction(boolean bl, String string, int n) {
        List list = this.getActionTokenList(n);
        for (NTAction nTAction : list) {
            if (!nTAction.getAssocToken().equals(string) || (bl ? 2 : 1) != nTAction.getEscalationLevel()) continue;
            return nTAction;
        }
        return null;
    }

    public void setAlertNotifMsg(boolean bl, int n, String string, int n2) {
        AlertNotifMsg alertNotifMsg = this.getNotifMsg(bl, n);
        if (alertNotifMsg == null) {
            alertNotifMsg = new AlertNotifMsg();
            alertNotifMsg.setNotifType(n);
            alertNotifMsg.setEsclationLevel(bl ? 2 : 1);
            this.notifMsgs.add(alertNotifMsg);
        }
        if (string != null) {
            alertNotifMsg.setNotifMessage(string);
        }
        alertNotifMsg.setNotifOptions(n2);
    }

    public void setRssFeedsNotifMsg(boolean bl, int n, String string, RssFeeds rssFeeds) {
        AlertNotifMsg alertNotifMsg = this.getNotifMsg(bl, n);
        if (alertNotifMsg == null) {
            alertNotifMsg = new AlertNotifMsg();
            this.notifMsgs.add(alertNotifMsg);
        }
        alertNotifMsg.setNotifType(n);
        alertNotifMsg.setEsclationLevel(bl ? 2 : 1);
        alertNotifMsg.setFeed(rssFeeds);
        if (string != null) {
            alertNotifMsg.setNotifMessage(string);
        }
    }

    public void setSaveAlertNotifMsg(boolean bl, int n, String string, SaveAlertToDisk saveAlertToDisk) {
        AlertNotifMsg alertNotifMsg = this.getNotifMsg(bl, n);
        if (alertNotifMsg == null) {
            alertNotifMsg = new AlertNotifMsg();
            this.notifMsgs.add(alertNotifMsg);
        }
        alertNotifMsg.setNotifType(n);
        alertNotifMsg.setEsclationLevel(bl ? 2 : 1);
        alertNotifMsg.setSaveAlertToDisk(saveAlertToDisk);
        if (string != null) {
            alertNotifMsg.setNotifMessage(string);
        }
    }

    public boolean isEscalationSelected() {
        return this.getReportingCriteria(2).getReportingOptions() != 0;
    }

    public boolean isEscalationSupported() {
        return this.getAllPossibleReporingOption(2) != 0;
    }

    public int getAllPossibleReporingOption(int n) {
        Iterator iterator = this.getAvailableAlertCriterias().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3;
            AlertCriteria alertCriteria = (AlertCriteria)iterator.next();
            ICriteria iCriteria = alertCriteria.getCriteria();
            int n4 = n3 = n == 2 ? iCriteria.getEscalateReportOption() : iCriteria.getReportOption();
            if (n2 == 0) {
                n2 = n3;
                continue;
            }
            n2 |= n3;
        }
        return n2;
    }

    public int getAvailableReportingOption(int n) {
        Iterator iterator = this.getCriteria().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3;
            AlertCriteria alertCriteria = (AlertCriteria)iterator.next();
            ICriteria iCriteria = alertCriteria.getCriteria();
            int n4 = n3 = n == 2 ? iCriteria.getEscalateReportOption() : iCriteria.getReportOption();
            if (n2 == 0) {
                n2 = n3;
                continue;
            }
            n2 |= n3;
        }
        return n2;
    }

    public Vector getTokensList(int n) {
        Iterator iterator = this.getCriteria().iterator();
        TreeSet<IdIdNameItem> treeSet = new TreeSet<IdIdNameItem>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == object2) {
                    return 0;
                }
                if (object != null && object2 != null) {
                    return object.toString().compareTo(object2.toString());
                }
                return 0;
            }
        });
        while (iterator.hasNext()) {
            AlertCriteria alertCriteria = (AlertCriteria)iterator.next();
            if (!alertCriteria.isSelected()) continue;
            for (IdIdNameItem idIdNameItem : alertCriteria.getCriteria().getTokenList()) {
                if ((idIdNameItem.getSecondId() & n) == 0) continue;
                treeSet.add(idIdNameItem);
            }
        }
        return new Vector(treeSet);
    }

    public ReportingCriteria getReportingCriteria(int n) {
        return this.repCriterias[n - 1];
    }

    public void setReportingCriteria(int n, ReportingCriteria reportingCriteria) {
        this.repCriterias[n - 1] = reportingCriteria;
    }

    public String getXMLEntities() {
        if (this.jobBasedEnity != null) {
            return this.jobBasedEnity;
        }
        return this.getEntityLoader().createXMLEntity(this.rootEntity);
    }

    public void setModificationBit(int n) {
        this.modificationBit |= n;
    }

    public int getModificationBit() {
        return this.modificationBit;
    }

    public Entity getRootEntity() {
        if (this.rootEntity == null) {
            this.rootEntity = new EntityImpl(this.getAlertType().getRootNodeType());
        }
        return this.rootEntity;
    }

    public AlertEntityLoader getEntityLoader() {
        return this.getAlertServerObject().getEntityLoader();
    }

    public List<GenericEntity> getEntitList() {
        return this.entitList;
    }

    public void setEntitList(List<GenericEntity> list) {
        this.entitList = list;
    }

    public void setXMLEntities(String string) {
        Logger.write(Logger.INFO, this, "XMLString", string);
        this.rootEntity = new EntityImpl(this.getAlertType().getRootNodeType());
        try {
            this.getEntityLoader().loadXMLEntities(this.rootEntity, string);
        }
        catch (Exception exception) {
            Logger.write(Logger.ERROR, this, "XMLString", exception);
        }
        if (this.rootEntity != null && this.rootEntity.getChildren() != null) {
            for (Entity entity : this.rootEntity.getChildren()) {
                if (entity == null) continue;
                EntityImpl.selectLeafNode(entity, true);
            }
        }
    }

    public void setJobBasedEntity(String string) {
        this.jobBasedEnity = string;
    }

    public String getJobBasedEntity() {
        return this.jobBasedEnity;
    }

    public void setJobBasedAlert(boolean bl) {
        this.jobBasedAlert = bl;
    }

    public boolean isJobBasedAlert() {
        return this.jobBasedAlert;
    }

    public void setCriteria(List<AlertCriteria> list) {
        this.criteria = list;
    }

    public List getExternalGroupList() {
        return this.externalGroupList;
    }

    public void setExternalGroupList(List list) {
        this.externalGroupList = list;
    }

    public List<IdIdNameItem> getNonGalaxyUserList() {
        return this.nonGalaxyUserList;
    }

    public void setNonGalaxyUserList(List<IdIdNameItem> list) {
        this.nonGalaxyUserList = list;
    }

    public int getRemoteCmdAssoc() {
        return this.remoteCmdAssoc;
    }

    public void setRemoteCmdAssoc(int n) {
        this.remoteCmdAssoc = n;
    }

    public void setLocale(IdNameItem idNameItem) {
        this.locale = idNameItem;
    }

    public IdNameItem getLocale() {
        return this.locale;
    }

    public List<IdIdNameItem> getNonGalaxyUserListCc() {
        return this.nonGalaxyUserListCc;
    }

    public void setNonGalaxyUserListCc(List<IdIdNameItem> list) {
        this.nonGalaxyUserListCc = list;
    }

    public List<IdIdNameItem> getNonGalaxyUserListBcc() {
        return this.nonGalaxyUserListBcc;
    }

    public void setNonGalaxyUserListBcc(List<IdIdNameItem> list) {
        this.nonGalaxyUserListBcc = list;
    }

    public List<IdIdNameItem> getToUsersList(int n) {
        return this.getUsersList(n, this.getUserListTo(), this.getNonGalaxyUserList(), this.getUserGroupList(), this.getExternalGroupList());
    }

    public List<IdIdNameItem> getCcUsersList(int n) {
        return this.getUsersList(n, this.getUserListCc(), this.getNonGalaxyUserListCc(), this.getUserGroupListCc(), this.getExternalUserGroupListCc());
    }

    public List<IdIdNameItem> getBccUsersList(int n) {
        return this.getUsersList(n, this.getUserListBcc(), this.getNonGalaxyUserListBcc(), this.getUserGroupListBcc(), this.getExternalUserGroupListBcc());
    }

    List<IdIdNameItem> getUsersList(int n, List<IdIdNameItem> list, List<IdIdNameItem> list2, List<IdIdNameItem> list3, List<IdIdNameItem> list4) {
        IdIdNameItem idIdNameItem;
        ArrayList<IdIdNameItem> arrayList = new ArrayList<IdIdNameItem>();
        if (list2 != null) {
            for (IdIdNameItem idIdNameItem2 : list2) {
                if (idIdNameItem2.getSecondId() != n) continue;
                idIdNameItem = new IdIdNameItem(0, 5, idIdNameItem2.getName());
                arrayList.add(idIdNameItem);
            }
        }
        if (list != null) {
            for (IdIdNameItem idIdNameItem2 : list) {
                if (idIdNameItem2.getSecondId() != n) continue;
                idIdNameItem = new IdIdNameItem(idIdNameItem2.getFirstId(), 1, idIdNameItem2.getName());
                arrayList.add(idIdNameItem);
            }
        }
        if (list3 != null) {
            for (IdIdNameItem idIdNameItem2 : list3) {
                if (idIdNameItem2.getSecondId() != n) continue;
                idIdNameItem = new IdIdNameItem(idIdNameItem2.getFirstId(), 2, idIdNameItem2.getName());
                arrayList.add(idIdNameItem);
            }
        }
        if (list4 != null) {
            for (IdIdNameItem idIdNameItem2 : list4) {
                if (idIdNameItem2.getSecondId() != n) continue;
                idIdNameItem = new IdIdNameItem(idIdNameItem2.getFirstId(), 4, idIdNameItem2.getName());
                arrayList.add(idIdNameItem);
            }
        }
        return arrayList;
    }

    public boolean isUserPageApplicable() {
        boolean bl = true;
        if (this.alertDetails != null) {
            bl = (this.alertDetails.getStatus() & 0x80) == 0 && !this.isCustomRecipientColumnSupported;
        }
        return bl;
    }

    public static class AlertUser {
        private int id;
        private int criteria;
        private int userType;
        private String userName;

        public AlertUser(int n, int n2, int n3, String string) {
            this.id = n;
            this.criteria = n2;
            this.userType = n3;
            this.userName = string;
        }

        public IdIdNameItem getUserItemIfCriteriaMatches(int n) {
            if (this.criteria == n) {
                return new IdIdNameItem(this.id, this.userType, this.userName);
            }
            return null;
        }

        public boolean matchesCriteria(int n) {
            return this.criteria == n;
        }

        public void addUserNameForMatchingCriteria(int n, List<String> list) {
            if (this.criteria == n) {
                list.add(this.userName);
            }
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public int getCriteria() {
            return this.criteria;
        }

        public void setCriteria(int n) {
            this.criteria = n;
        }

        public int getUserType() {
            return this.userType;
        }

        public void setUserType(int n) {
            this.userType = n;
        }
    }
}

