/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.alert.model.Alert;
import commvault.cte.component.tree.AlertMultiStateTreeNode;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityContext;
import commvault.cte.component.tree.EntityLoader;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.cte.component.tree.NodeType;
import commvault.msgs.CvEntities.EntityFlags;
import commvault.msgs.CvEntities.GenericEntity;
import java.util.ArrayList;
import java.util.List;

public class AlertEntityContext
implements EntityContext {
    private static Alert alert;
    protected ArrayList<GenericEntity> selectedEntities;
    protected ArrayList<GenericEntity> excludedEntities;
    private int mode;

    public AlertEntityContext(Alert alert, int n) {
        AlertEntityContext.alert = alert;
        this.mode = n;
    }

    public static Alert getAlert() {
        return alert;
    }

    @Override
    public EntityLoader getEntityLoader() {
        return alert.getEntityLoader();
    }

    @Override
    public List<EntityTreeNode> getEntityNodes(NodeType nodeType, Entity entity) {
        ArrayList<EntityTreeNode> arrayList = new ArrayList<EntityTreeNode>();
        Entity[] entityArray = this.getEntityLoader().getEntities(nodeType, entity, alert.getAlertType().getAlertTypeId());
        boolean bl = AlertEntityContext.getAlert().getAlertType().getAlertTypeId() == 65 && this.mode == 1;
        for (Entity entity2 : entityArray) {
            if (bl && entity2.getId() == 2) {
                entity2.setSelected(true);
            }
            arrayList.add(new AlertMultiStateTreeNode(entity2, this));
        }
        return arrayList;
    }

    @Override
    public boolean isSelectable(Entity entity) {
        return true;
    }

    @Override
    public boolean isVisibilitySupported() {
        return false;
    }

    @Override
    public List<GenericEntity> getSelectedEntities() {
        if (this.selectedEntities == null) {
            this.initSelectedAndExcludedEntities();
        }
        return this.selectedEntities;
    }

    @Override
    public List<GenericEntity> getExcludedEntities() {
        if (this.excludedEntities == null) {
            this.initSelectedAndExcludedEntities();
        }
        return this.excludedEntities;
    }

    protected void initSelectedAndExcludedEntities() {
        List<GenericEntity> list;
        if (this.selectedEntities == null) {
            this.selectedEntities = new ArrayList();
        }
        if (this.excludedEntities == null) {
            this.excludedEntities = new ArrayList();
        }
        if ((list = alert.getEntitList()) != null) {
            for (GenericEntity genericEntity : list) {
                EntityFlags entityFlags = genericEntity.getFlags();
                boolean bl = false;
                if (entityFlags != null) {
                    bl = entityFlags.getExclude();
                }
                if (bl) {
                    this.excludedEntities.add(genericEntity);
                    continue;
                }
                this.selectedEntities.add(genericEntity);
            }
        }
    }
}

