/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLFormatter
extends XMLOutputter {
    private String namespace = null;
    private int nbInlineAttribs;

    public static String formatXml(String string) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build((Reader)new StringReader(string));
        XMLFormatter xMLFormatter = new XMLFormatter(null, 1);
        Format format = xMLFormatter.getFormat();
        format.setIndent("  ");
        format.setLineSeparator(System.getProperty("line.separator"));
        xMLFormatter.setFormat(format);
        StringWriter stringWriter = new StringWriter();
        xMLFormatter.output(document.getRootElement(), stringWriter);
        stringWriter.close();
        return stringWriter.toString();
    }

    public XMLFormatter(String string, int n) {
        this.namespace = string;
        this.nbInlineAttribs = n;
    }

    private static int elementDepth(Element element) {
        int n = 0;
        while (element != null) {
            ++n;
            element = element.getParentElement();
        }
        return n;
    }

    protected void printAttributes(Writer writer, List list, Element element, XMLOutputter.NamespaceStack namespaceStack) throws IOException {
        Object object;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Object object2 : list) {
            object = (Attribute)object2;
            Attribute attribute = new Attribute(object.getName(), object.getValue());
            arrayList.add(attribute);
        }
        Collections.sort(arrayList, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                return attribute.getName().compareToIgnoreCase(attribute2.getName());
            }
        });
        for (Attribute attribute : arrayList) {
            if ((this.namespace == null || this.namespace.equals(attribute.getNamespaceURI())) && list.size() > this.nbInlineAttribs) {
                writer.append("\n");
                for (int i = 0; i < XMLFormatter.elementDepth(element); ++i) {
                    writer.append(this.getFormat().getIndent());
                }
            }
            object = new ArrayList();
            object.add(attribute);
            super.printAttributes(writer, (List)object, element, namespaceStack);
        }
    }
}

