/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.xml.PasswordEncryptType;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.APIResponse;
import commvault.cte.workflow.utils.RequestMethod;
import commvault.cte.workflow.utils.RequestObject;
import commvault.cte.workflow.utils.UploadException;
import commvault.cte.workflow.utils.UploadTask;
import commvault.msgs.App.FileMetaData;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.GenericEntity;
import commvault.msgs.DM2ContentIndexing.FileData;
import commvault.msgs.DM2ContentIndexing.UploadFileReq;
import commvault.msgs.DM2ContentIndexing.UploadFileResp;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class UploadUtils {
    protected static final int MB_IN_BYTES = 0x100000;
    protected static final int DATACHUNK_MAXLENGTH = 0x100000;
    private String baseUrl;
    private static final String CONTENT_TYPE_BINARY = "application/octet-stream";
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UploadUtils.class);
    static final String RETURN_FILE_EXISTS = "FileExists";
    static final String RETURN_SUCCESS = "Success";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String TOKEN_HEADER_KEY = "Cookie2";
    String CONTENT_TYPE_XML = "application/xml";
    String LOOKUPNAME_HEADER_KEY = "LookupNames";
    static final Integer ERROR_CODE_3020 = new Integer(3020);
    static final Integer ERROR_CODE_1001 = new Integer(1001);
    static final Integer ERROR_CODE_1002 = new Integer(1002);
    static final Integer ERROR_CODE_101 = new Integer(101);
    static final Integer ERROR_CODE_2001 = new Integer(2001);
    static final Integer ERROR_CODE_2002 = new Integer(2002);
    static final Integer ERROR_CODE_2003 = new Integer(2003);
    static final Integer ERROR_CODE_2005 = new Integer(2005);
    static final Integer ERROR_CODE_2010 = new Integer(2010);
    static final Integer ERROR_CODE_3024 = new Integer(3024);
    static final Integer ERROR_CODE_413 = new Integer(413);

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    private long streamsCopy(InputStream inputStream, OutputStream outputStream, boolean bl, long l) throws IOException {
        int n;
        if (inputStream == null) {
            return -1L;
        }
        if (outputStream == null) {
            return -1L;
        }
        long l2 = 0L;
        InputStream inputStream2 = inputStream;
        OutputStream outputStream2 = outputStream;
        int n2 = 4096;
        byte[] byArray = new byte[4096];
        if (l > 0L && l > 4096L) {
            n2 = 4096;
        }
        while ((n = inputStream2.read(byArray, 0, n2)) != -1) {
            if (n > 0) {
                l2 += (long)n;
                if (outputStream2 != null) {
                    outputStream2.write(byArray, 0, n);
                }
            }
            if (l <= 0L) continue;
            if (l2 >= l) break;
            if (l - l2 > 4096L) continue;
            n2 = (int)(l - l2);
        }
        if (outputStream2 != null) {
            if (bl) {
                outputStream2.close();
            } else {
                outputStream2.flush();
            }
            outputStream2 = null;
        }
        inputStream2 = null;
        return l2;
    }

    private void createHeaderChunk(ByteArrayOutputStream byteArrayOutputStream, boolean bl, UploadTask uploadTask) {
        if (uploadTask == null) {
            return;
        }
        try {
            UploadFileReq uploadFileReq = null;
            String string = "";
            FileData fileData = new FileData();
            fileData.setFileSize(uploadTask.getFileSize().longValue());
            fileData.setFileName(uploadTask.getFileName());
            FileMetaData fileMetaData = new FileMetaData();
            fileMetaData.setDataType(1);
            UploadFileReq uploadFileReq2 = new UploadFileReq();
            uploadFileReq2.setFileContent(fileData);
            GenericEntity genericEntity = new GenericEntity();
            genericEntity.set_type_(EntityType.CLIENT_ENTITY);
            uploadFileReq2.setDestEntity(genericEntity);
            uploadFileReq2.setFileMetaData(fileMetaData);
            string = UploadUtils.encodeXml(uploadFileReq2, false);
            uploadFileReq = uploadFileReq2;
            this.createDataChunk(byteArrayOutputStream, bl, string, true, uploadTask.isResumeUpload());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.info("Error: " + exception.getMessage());
        }
    }

    public static String encodeXml(Object object, boolean bl) throws Exception {
        return XMLEncoder.encode((Object)object, (PasswordEncryptType)PasswordEncryptType.PLAIN_TEXT, (boolean)bl);
    }

    private final void createDataChunk(ByteArrayOutputStream byteArrayOutputStream, boolean bl, String string, boolean bl2, boolean bl3) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(7 + byArray.length);
            byteArrayOutputStream2.write(1);
            if (bl2 && !bl3) {
                byteArrayOutputStream2.write(1);
            } else if (bl2 && bl3) {
                byteArrayOutputStream2.write(3);
            } else {
                byteArrayOutputStream2.write(2);
            }
            byteArrayOutputStream2.write(bl ? 1 : 0);
            byte[] byArray2 = ByteBuffer.allocate(4).putInt(byArray.length).array();
            for (int i = 0; i < 4; ++i) {
                byteArrayOutputStream2.write(byArray2[3 - i]);
            }
            byteArrayOutputStream2.write(byArray);
            if (byteArrayOutputStream.size() > 0) {
                byteArrayOutputStream.writeTo(byteArrayOutputStream2);
                byteArrayOutputStream.reset();
            }
            byteArrayOutputStream2.writeTo(byteArrayOutputStream);
            logger.info("Size of Data Chunk: " + byteArrayOutputStream.size());
        }
        catch (Exception exception) {
            logger.info("Error: " + exception.getMessage());
        }
    }

    protected final String sendChunks(InputStream inputStream, UploadTask uploadTask) throws Exception {
        long l;
        long l2 = uploadTask.getChunkOffset() != null ? uploadTask.getChunkOffset() : 0L;
        long l3 = 0L;
        boolean bl = false;
        Boolean bl2 = null;
        Long l4 = uploadTask.getFileSize();
        if (l4 == null) {
            l4 = -1L;
        }
        int n = 0x100000;
        long l5 = l = l4 > 0L && l4 > (long)n ? (long)n : l4;
        while (!bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            l3 = this.streamsCopy(inputStream, byteArrayOutputStream, true, l);
            if (l3 <= 0L) {
                bl = true;
            } else if (l4 > 0L) {
                bl = l4 == l2 + l3;
            } else {
                bl = true;
                uploadTask.setFileSize(1L * l3);
            }
            if (uploadTask.getRequestId() == null || uploadTask.getRequestId().isEmpty()) {
                if (inputStream == null) {
                    bl = l4 <= 0L;
                }
                uploadTask.setEndOfFile(bl);
                this.createHeaderChunk(byteArrayOutputStream, bl, uploadTask);
            } else {
                uploadTask.setEndOfFile(bl);
                this.createDataChunk(byteArrayOutputStream, bl, uploadTask.getRequestId(), false, false);
            }
            bl2 = this.sendToServer(uploadTask, byteArrayOutputStream);
            l2 += l3;
            if (l4 <= 0L) continue;
            long l6 = l4 - l2;
            l = l6 > (long)n || l6 <= 0L ? (long)n : l6;
        }
        return bl2 != null && bl2 != false ? RETURN_FILE_EXISTS : RETURN_SUCCESS;
    }

    private HttpEntity setParamsAndBuildEntity(RequestObject requestObject, String string, HttpRequestBase httpRequestBase) throws UnsupportedEncodingException {
        ByteArrayEntity byteArrayEntity = null;
        if (requestObject.getReqContentType() == CONTENT_TYPE_BINARY) {
            Object object = requestObject.getReqObject();
            if (object instanceof byte[]) {
                byteArrayEntity = new ByteArrayEntity((byte[])requestObject.getReqObject());
            } else {
                throw new RuntimeException("Invalid request. Req content type is binary but the payload isn't byte array. When building the RequestObject with new RequestObject(String url, Object reqObject) instance pass the second arguement as byte[].");
            }
        }
        return byteArrayEntity;
    }

    public static String urlEncode(String string) {
        try {
            URL uRL = new URL(string);
            URI uRI = new URI(uRL.getProtocol(), uRL.getAuthority(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            return uRI.toURL().toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected APIResponse getServerResponse(RequestObject requestObject) throws Exception {
        String string = "";
        String string2 = requestObject.getApi();
        Integer n = requestObject.getTimeout();
        try {
            Header[] headerArray;
            String string3;
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(n.intValue()).setSocketTimeout(n.intValue()).build()).build();
            String string4 = null;
            string2 = UploadUtils.urlEncode(string2);
            HttpEntity httpEntity = null;
            String string5 = string2;
            RequestMethod requestMethod = requestObject.getRequestMethod();
            string2 = string5;
            if (requestMethod == RequestMethod.POST) {
                string3 = new HttpPost(string2);
                httpEntity = this.setParamsAndBuildEntity(requestObject, string, (HttpRequestBase)string3);
                string3.setEntity(httpEntity);
                string4 = string3;
            }
            if ((string3 = requestObject.getReqContentType()) == null) {
                string3 = this.CONTENT_TYPE_XML;
            }
            string4.setHeader(CONTENT_TYPE_HEADER, string3);
            if (requestObject.getOverrideCookieToken() != null) {
                string4.setHeader(TOKEN_HEADER_KEY, requestObject.getOverrideCookieToken());
            }
            if (requestObject.getAcceptHeader() != null && !requestObject.getAcceptHeader().isEmpty()) {
                string4.setHeader("Accept", requestObject.getAcceptHeader());
            }
            string4.setHeader(this.LOOKUPNAME_HEADER_KEY, "false");
            string4.setHeader("FormatOutput", "false");
            string4.setHeader("SkipOldJsonConverter", "true");
            if (string == null || string.isEmpty()) {
                string4.removeHeaders(CONTENT_TYPE_HEADER);
            }
            HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)string4);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            APIResponse aPIResponse = new APIResponse();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Header header : headerArray = httpResponse.getAllHeaders()) {
                hashMap.put(header.getName(), header.getValue());
            }
            aPIResponse.setHeaders(hashMap);
            String string6 = this.convertResponseEntityToString(httpResponse.getEntity());
            aPIResponse.setResponse(string6);
            return aPIResponse.setStatus(n2);
        }
        catch (IOException iOException) {
            throw new Exception("Unable to contact the server");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String convertResponseEntityToString(HttpEntity httpEntity) throws Exception {
        String string;
        if (httpEntity == null) {
            return "";
        }
        InputStream inputStream = httpEntity.getContent();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    private APIResponse getResponseAndHandleExceptions(RequestObject requestObject) throws Exception {
        APIResponse aPIResponse = this.getServerResponse(requestObject);
        int n = aPIResponse.getStatus();
        switch (n) {
            case 401: {
                throw new Exception("Unauthorized: Access is denied ");
            }
        }
        return aPIResponse;
    }

    private static UploadFileResp convertStringResponseToObject(String string, String string2) throws Exception {
        if (string.isEmpty()) {
            throw new Exception("Failed to convert response to object: response is empty");
        }
        return (UploadFileResp)XMLDecoder.decode((String)string);
    }

    public UploadFileResp getUploadResponse(RequestObject requestObject) throws Exception {
        UploadFileResp uploadFileResp;
        APIResponse aPIResponse = this.getResponseAndHandleExceptions(requestObject);
        String string = aPIResponse.getResponse();
        UploadFileResp uploadFileResp2 = uploadFileResp = UploadUtils.convertStringResponseToObject(string, requestObject.getRespContentType());
        return uploadFileResp2;
    }

    protected final Boolean sendToServer(UploadTask uploadTask, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        Boolean bl = null;
        String string = this.getUploadUrl(uploadTask);
        RequestObject requestObject = RequestObject.post(string, byteArrayOutputStream.toByteArray());
        requestObject.setReqContentType(CONTENT_TYPE_BINARY);
        requestObject.setTimeout(new Integer(600000));
        requestObject.setOverrideCookieToken(uploadTask.getOverrideCookieToken());
        UploadFileResp uploadFileResp = this.getUploadResponse(requestObject);
        if (uploadFileResp != null && uploadFileResp.getErrorCode(false) != null && uploadFileResp.getErrorCode() != 0) {
            if (ERROR_CODE_2001.equals(uploadFileResp.getErrorCode())) {
                if (uploadTask.getRequestId() == null || uploadTask.getRequestId().isEmpty()) {
                    bl = Boolean.TRUE;
                }
            } else {
                String string2 = null;
                int n = uploadFileResp.getErrorCode();
                string2 = ERROR_CODE_3020.equals(n) ? "Folder with same name already exists." : (ERROR_CODE_1001.equals(n) ? "Activity disabled, contact Administrator." : (ERROR_CODE_2002.equals(n) ? "Permission denied, contact the Administrator" : (ERROR_CODE_1002.equals(n) ? "A file name cannot contain any of the following characters: \\\\\\\\ / : * ? \" < > |" : (ERROR_CODE_101.equals(n) ? uploadFileResp.getErrorString() : (ERROR_CODE_2003.equals(n) ? "Administrator has blocked the uploads of this file type." : (ERROR_CODE_413.equals(n) ? "Edge drive quota exceeded" : (ERROR_CODE_2005.equals(n) ? "You do not have permission to upload." : (ERROR_CODE_2010.equals(n) ? "The computer user account is not set." : (ERROR_CODE_3024.equals(n) ? "You do not have permission to perform this operation." : "Something went wrong. Please try again.")))))))));
                throw new UploadException(n, string2);
            }
        }
        if (uploadFileResp != null) {
            if (uploadFileResp.getRequestId(false) != null) {
                uploadTask.setRequestId(uploadFileResp.getRequestId());
            }
            if (uploadFileResp.getChunkOffset(false) != null) {
                uploadTask.setChunkOffset(uploadFileResp.getChunkOffset());
            }
            if (uploadFileResp.getFileGUID(false) != null) {
                uploadTask.setFileGUID(uploadFileResp.getFileGUID());
            }
        }
        return bl;
    }

    private String getUploadUrl(UploadTask uploadTask) {
        return this.getBaseUrl() + "/ContentAnalyzer/" + uploadTask.getCaCloudId() + "/action/uploadFile?entityId=" + uploadTask.getEntityId() + "&entityKey=" + uploadTask.getEntityKey() + "&waitForCopy=true";
    }

    public static boolean upload(String string, String string2, String string3, Integer n, String string4, String string5) throws Exception {
        UploadTask uploadTask = new UploadTask();
        if (string3 != null && !string3.startsWith("QSDK")) {
            string3 = "QSDK " + string3;
        }
        uploadTask.setOverrideCookieToken(string3);
        File file = new File(string2);
        uploadTask.setFileSize(file.length());
        uploadTask.setFileName(file.getName());
        uploadTask.setCaCloudId(n);
        uploadTask.setEntityId(string4);
        uploadTask.setEntityKey(string5);
        UploadUtils uploadUtils = new UploadUtils();
        uploadUtils.setBaseUrl(string);
        try {
            uploadUtils.sendChunks(new FileInputStream(file), uploadTask);
        }
        catch (Exception exception) {
            if (exception instanceof UploadException) {
                UploadException uploadException = (UploadException)exception;
                logger.info("Upload failed : error code [" + uploadException.getErrorCode() + " error message [" + uploadException.getErrorString() + "]");
            } else {
                logger.info("Upload failed : error message [" + exception.getMessage() + "]");
            }
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

