/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.Base64;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.ExecuteWorkflow;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.UploadUtils;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;
import commvault.msgs.Workflow.PopupInputRequest;
import commvault.msgs.Workflow.PopupInputResponse;
import commvault.qnet.sys.CVPassword;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import workflow.types.EncryptedString;
import workflow.types.XML;

public class ScriptUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ScriptUtils.class);
    private WorkflowContext workflow;

    public ScriptUtils(WorkflowContext workflowContext) {
        this.workflow = workflowContext;
    }

    public String getWebServerUrl() throws Exception {
        WorkflowProperties.WebServiceParameters webServiceParameters = WorkflowProperties.getInstance().getDefaultWebServiceParameters();
        if (webServiceParameters != null) {
            return webServiceParameters.getWebUrl() + webServiceParameters.getBasePath();
        }
        return "";
    }

    public int getWebServerClientId() throws Exception {
        WorkflowProperties.WebServiceParameters webServiceParameters = WorkflowProperties.getInstance().getDefaultWebServiceParameters();
        if (webServiceParameters != null) {
            return webServiceParameters.getClientId();
        }
        return 0;
    }

    public Boolean upload(String string, String string2, Integer n, String string3, String string4) throws Exception {
        return UploadUtils.upload(this.getWebServerUrl(), string, string2, n, string3, string4);
    }

    public String formatDate(Calendar calendar, String string) {
        return DateFormatUtils.format((Calendar)calendar, (String)string);
    }

    public String formatDate(java.util.Date date, String string) {
        return DateFormatUtils.format((java.util.Date)date, (String)string);
    }

    public String formatDate(Calendar calendar) {
        return DateFormatUtils.format((Calendar)calendar, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public String formatDate(java.util.Date date) {
        return DateFormatUtils.format((java.util.Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public String getSqlTimestamp(Calendar calendar) {
        return this.getSqlTimestamp(calendar.getTime());
    }

    public String getSqlTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime()).toString();
    }

    public String getSqlDate(Calendar calendar) {
        return this.getSqlTimestamp(calendar.getTime());
    }

    public String getSqlDate(java.util.Date date) {
        return new Date(date.getTime()).toString();
    }

    public String join(List list, char c) {
        return this.join(list, String.valueOf(c));
    }

    public String join(List list, String string) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e != null) {
                stringBuffer.append(String.valueOf(list.get(0)));
            }
            if (i >= list.size() - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public XML parseXml(String string) throws EvFailureException {
        return WorkflowElement.parse(string);
    }

    public EncryptedString encryptString(String string) {
        CVPassword cVPassword = new CVPassword();
        return new EncryptedString(cVPassword.encrypt(string));
    }

    public EncryptedString encryptString(String string, int n) {
        CVPassword cVPassword = new CVPassword();
        return new EncryptedString(cVPassword.encrypt(string));
    }

    public EncryptedString encryptStrong(String string, String string2) {
        CVPassword cVPassword = new CVPassword();
        return new EncryptedString(cVPassword.encryptStrong(string, string2));
    }

    public EncryptedString encryptStrong(EncryptedString encryptedString, String string) {
        String string2 = encryptedString.getPlainText();
        CVPassword cVPassword = new CVPassword();
        return new EncryptedString(cVPassword.encryptStrong(string2, string));
    }

    public String decryptString(String string) {
        CVPassword cVPassword = new CVPassword();
        return cVPassword.decrypt(string);
    }

    public String decryptString(EncryptedString encryptedString) {
        return encryptedString.getPlainText();
    }

    public String encode(EncryptedString encryptedString) {
        return this.encodePassword(encryptedString);
    }

    public String encodePassword(EncryptedString encryptedString) {
        String string = Base64.encodeToString((byte[])encryptedString.getEncryptedText().getBytes());
        return "||#5!" + string;
    }

    public String encodeString(String string) {
        return EncoderUtil.encodeString((String)string);
    }

    public String executeWorkflow(String string, String string2) throws Exception {
        ExecuteWorkflow executeWorkflow = new ExecuteWorkflow();
        executeWorkflow.setInputs(string2);
        ((ActivityContext)this.workflow).setActivityId(CommServUtils.getActivtyIdForWorkflow(string));
        executeWorkflow.execute((ActivityContext)this.workflow);
        return executeWorkflow.getOutputs();
    }

    public List<String> getColumnValues(String string) throws Exception {
        if (!this.workflow.getContext().isCommCellAdmin()) {
            throw new CTEDBException("impersonated user [" + this.workflow.getContext().getUser().getUserName() + "] does not have required capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "]");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try (CTEDBReservation cTEDBReservation = this.workflow.getContext().getCommCellConnection().createReservation();){
            Statement statement = cTEDBReservation.createStatement();
            if (!statement.execute(string)) {
                List<String> list = null;
                return list;
            }
            ResultSet resultSet = statement.getResultSet();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumnValues(String string, String string2, EncryptedString encryptedString, String string3) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = DriverManager.getConnection(string, string2, encryptedString.getPlainText());
        Statement statement = null;
        statement = connection.createStatement();
        if (!statement.execute(string3)) {
            List<String> list = null;
            return list;
        }
        ResultSet resultSet = statement.getResultSet();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2;
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public XML sendInteractiveRequest(String string, String string2, InputForm inputForm, ActivityContext activityContext) throws Exception {
        PopupInputResponse popupInputResponse = new PopupInputResponse();
        popupInputResponse.setInputForm(inputForm);
        popupInputResponse.setDescription(activityContext.getDescription());
        popupInputResponse.setSubject(string);
        RequestManager.populateInteractiveResponse((InteractiveResponse)popupInputResponse, activityContext);
        InteractiveScriptRequest interactiveScriptRequest = new InteractiveScriptRequest();
        SessionManager.getInstance().sendResponse(activityContext, (CTEProcessingModel)popupInputResponse, interactiveScriptRequest);
        logger.info(activityContext.getJobId(), "waiting on iteractive request from user [%s]", activityContext.getExecutor());
        activityContext.setFailureReason(String.format("waiting on user input [%s]", string));
        activityContext.getJobManager().updatePendingReason();
        activityContext.setStatus(ProcessStatus.WAITING);
        while (true) {
            if (interactiveScriptRequest.sessionClosed) {
                logger.warn(activityContext.getJobId(), "session was closed");
                return null;
            }
            if (interactiveScriptRequest.request != null) {
                if (interactiveScriptRequest.request.getOkClicked()) {
                    return WorkflowElement.parse(((PopupInputRequest)interactiveScriptRequest.request).getInputXml());
                }
                return null;
            }
            Thread.sleep(1000L);
        }
    }

    private class InteractiveScriptRequest
    implements InteractiveAction {
        private InteractiveRequest request = null;
        private boolean sessionClosed = false;

        private InteractiveScriptRequest() {
        }

        @Override
        public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
            this.request = interactiveRequest;
        }

        @Override
        public void onInteractiveSessionClosed() {
            this.sessionClosed = true;
        }
    }
}

