/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.workflow.annotations.Input;
import commvault.cte.common.workflow.annotations.Internal;
import commvault.cte.common.workflow.annotations.XmlField;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ReflectionUtils.class);

    public static Object newInstance(Class clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException, ClassNotFoundException {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            if (!Modifier.isPublic(constructorArray[i].getModifiers())) {
                constructorArray[i].setAccessible(true);
            }
            constructorArray[i].setAccessible(true);
            return constructorArray[i].newInstance(new Object[0]);
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return ReflectionUtils.instantiateUsingSerialization(clazz);
        }
        return clazz.newInstance();
    }

    public static Object instantiateUsingConstructors(Class clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            if (!Modifier.isPublic(constructorArray[i].getModifiers())) {
                constructorArray[i].setAccessible(true);
            }
            constructorArray[i].setAccessible(true);
            return constructorArray[i].newInstance(new Object[0]);
        }
        return clazz.newInstance();
    }

    public static Object instantiateUsingSerialization(Class clazz) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(-21267);
        dataOutputStream.writeShort(5);
        dataOutputStream.writeByte(115);
        dataOutputStream.writeByte(114);
        dataOutputStream.writeUTF(clazz.getName());
        dataOutputStream.writeLong(ObjectStreamClass.lookup(clazz).getSerialVersionUID());
        dataOutputStream.writeByte(2);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeByte(120);
        dataOutputStream.writeByte(112);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return objectInputStream.readObject();
    }

    public static boolean isOutputField(Field field) {
        return !(field.getAnnotation(Output.class) == null && field.getAnnotation(InputOutput.class) == null && field.getAnnotation(commvault.cte.workflow.annotations.Input.class) != null || field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class) == null && field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class) == null && field.getAnnotation(Input.class) != null);
    }

    public static boolean isInputField(Field field) {
        return !(field.getAnnotation(commvault.cte.workflow.annotations.Input.class) == null && field.getAnnotation(InputOutput.class) == null && field.getAnnotation(Output.class) != null || field.getAnnotation(Input.class) == null && field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class) == null && field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class) != null);
    }

    public static boolean isInternalField(Field field) {
        return field.getAnnotation(commvault.cte.workflow.annotations.Internal.class) != null && field.getAnnotation(Internal.class) != null;
    }

    public static List<Field> getAccessibleFields(Class clazz, boolean bl) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ReflectionUtils.addAccessibleFields(arrayList, clazz, bl);
        return arrayList;
    }

    private static void addAccessibleFields(List<Field> list, Class clazz, boolean bl) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getDeclaringClass().equals(clazz)) continue;
            if (field.getModifiers() == 1) {
                list.add(field);
                continue;
            }
            if (field.getModifiers() != 2 && field.getModifiers() != 4) continue;
            String string = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            if (field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class) != null || field.getAnnotation(XmlField.class) != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                list.add(field);
                continue;
            }
            try {
                clazz.getMethod("get" + string, null);
                clazz.getMethod("set" + string, field.getType());
                list.add(field);
            }
            catch (Exception exception) {
                if (!bl || !ReflectionUtils.isInternalField(field)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                list.add(field);
            }
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            ReflectionUtils.addAccessibleFields(list, clazz.getSuperclass(), bl);
        }
    }
}

