/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.Workflow.OutputFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;

public class OutputBuilder {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OutputBuilder.class);

    public static String buildOutputs(ProcessContext processContext, boolean bl) throws EvFailureException {
        return OutputBuilder.buildOutputs(processContext, processContext.getWorkflowExecution().getOutputs(), processContext.getOutputSchema(), bl);
    }

    public static String buildOutputs(ProcessContext processContext, WorkflowElement workflowElement, XMLSchema xMLSchema, boolean bl) throws EvFailureException {
        WorkflowEvaluator workflowEvaluator;
        if (workflowElement == null || workflowElement.getChildren().size() == 0) {
            logger.debug(processContext.getJobId(), "no outputs were defined in definition, skip creating output xml");
            return "";
        }
        logger.debug(processContext.getJobId(), "begin processing expressions for workflow outputs, xml [%s]", processContext.getOutputXml());
        try {
            workflowEvaluator = new WorkflowEvaluator(new EvalManager(processContext));
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to instantiate workflow evaluator");
            throw evFailureException;
        }
        try {
            workflowEvaluator.processElement(workflowElement);
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to process expressions in output xml [" + processContext.getOutputXml() + "]");
            throw evFailureException;
        }
        if (processContext.getOutputFormat() == OutputFormat.XML) {
            if (!bl) {
                WorkflowUtils.removeSystemAttributes(workflowElement);
            }
            return workflowElement.toString();
        }
        try {
            return OutputBuilder.getJsonOutputs(processContext, workflowEvaluator.getObjectMap(workflowElement, xMLSchema, false));
        }
        catch (Throwable throwable) {
            logger.error(processContext.getJobId(), "failed to build json outputs", throwable);
            throw new EvFailureException(new EvMessageContainer(throwable.getMessage()));
        }
    }

    private static String getJsonOutputs(ProcessContext processContext, Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof DataSet) {
                DataSet dataSet = (DataSet)entry.getValue();
                ArrayList arrayList = new ArrayList();
                for (DataRow dataRow : dataSet.getRows()) {
                    LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
                    arrayList.add(linkedHashMap2);
                    for (int i = 0; i < dataRow.getColumnCount(); ++i) {
                        linkedHashMap2.put(dataRow.getColumnName(i), dataRow.get(i));
                    }
                }
                linkedHashMap.put(entry.getKey(), arrayList);
                continue;
            }
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        String string = OutputBuilder.getJsonString(linkedHashMap);
        return OutputBuilder.convertChildJsonElements(string);
    }

    public static String convertChildJsonElements(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        JSONObject jSONObject = new JSONObject(string);
        for (String string2 : jSONObject.keySet()) {
            Object object = jSONObject.get(string2);
            if (object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                for (int i = 0; i < jSONArray.length(); ++i) {
                    Object object2 = jSONArray.get(i);
                    jSONArray.put(i, OutputBuilder.checkObject(object2));
                }
                continue;
            }
            jSONObject.put(string2, OutputBuilder.checkObject(object));
        }
        return jSONObject.toString();
    }

    private static Object checkObject(Object object) {
        if (object == null) {
            return object;
        }
        String string = String.valueOf(object);
        if (string.startsWith("{")) {
            try {
                return new JSONObject(string);
            }
            catch (Throwable throwable) {
                return object;
            }
        }
        if (string.startsWith("[")) {
            try {
                return new JSONArray(string);
            }
            catch (Throwable throwable) {
                return object;
            }
        }
        return object;
    }

    public static String getJsonString(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getName().equals("_type_");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.equals(EntityType.class) || clazz.getName().startsWith("com.jgoodies");
            }
        }});
        if (object != null) {
            JsonElement jsonElement = null;
            jsonElement = gsonBuilder.create().toJsonTree(object, object.getClass());
            if (!jsonElement.isJsonNull() && jsonElement.isJsonObject()) {
                return ((JsonObject)jsonElement).toString();
            }
        }
        return null;
    }
}

