/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;

public class MailClient {
    private String host;
    private String userName;
    private String password;
    private boolean ssl;
    private String folderName;
    private Session session;
    private Store store;
    private Folder folder;

    public MailClient(String string, String string2, String string3, String string4, boolean bl) {
        this.host = string;
        this.userName = string2;
        this.password = string3;
        this.folderName = string4;
        this.ssl = bl;
    }

    public void connect() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("mail.store.protocol", "imaps");
        if (this.ssl) {
            properties.setProperty("mail.imap.ssl.enable", "true");
        }
        this.session = Session.getInstance((Properties)properties, null);
        this.store = this.session.getStore();
        this.store.connect(this.host, this.userName, this.password);
        this.folder = this.store.getFolder(this.folderName);
    }

    public void close() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
    }

    public Message[] getMessages() throws Exception {
        FlagTerm flagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
        Message[] messageArray = this.folder.search((SearchTerm)flagTerm);
        if (messageArray == null) {
            return new Message[0];
        }
        return messageArray;
    }

    public void move(Message message, String string) throws Exception {
        Folder folder = this.store.getFolder(string);
        this.folder.copyMessages(new Message[]{message}, folder);
        message.setFlag(Flags.Flag.DELETED, true);
        this.folder.expunge();
    }

    public static String read(Message message) throws Exception {
        message.setFlag(Flags.Flag.SEEN, true);
        if (message.getContent() instanceof String) {
            return String.valueOf(message.getContent());
        }
        if (message.isMimeType("multipart/*")) {
            MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            int n = mimeMultipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                if (!(bodyPart.getContent() instanceof String)) continue;
                return String.valueOf(bodyPart.getContent());
            }
            return "";
        }
        return "";
    }
}

