/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.workflow.logger.CTELogger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.DOMBuilder;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.DOMOutputter;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Element;

public class JDOMUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JDOMUtil.class);

    public static org.jdom2.Element parseXml(String string) throws JDOMException {
        if (string != null && string.length() > 0) {
            Document document;
            SAXBuilder sAXBuilder = new SAXBuilder();
            try {
                document = sAXBuilder.build((Reader)new StringReader(string));
            }
            catch (IOException iOException) {
                logger.error("error loading xml [" + string + "]", iOException);
                return null;
            }
            return document.getRootElement();
        }
        return null;
    }

    public static Element convertToDOM(org.jdom2.Element element) throws Exception {
        Document document = new Document(element.clone());
        DOMOutputter dOMOutputter = new DOMOutputter();
        org.w3c.dom.Document document2 = dOMOutputter.output(document);
        return document2.getDocumentElement();
    }

    public static org.jdom2.Element convertFromDOM(org.w3c.dom.Document document) {
        if (document != null) {
            DOMBuilder dOMBuilder = new DOMBuilder();
            Document document2 = dOMBuilder.build(document);
            return document2.getRootElement();
        }
        return null;
    }

    public static org.jdom2.Element convertFromDOM(Element element) {
        if (element != null) {
            DOMBuilder dOMBuilder = new DOMBuilder();
            return dOMBuilder.build(element);
        }
        return null;
    }

    public static String serializeXml(org.jdom2.Element element) throws IOException {
        if (element != null) {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(element, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        return null;
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof org.jdom2.Element) {
            return JDOMUtil.serialize((org.jdom2.Element)object);
        }
        return String.valueOf(object);
    }

    public static String toString(List list) {
        if (list == null) {
            return null;
        }
        if (list.size() > 0 && list.get(0) instanceof org.jdom2.Element) {
            return JDOMUtil.serialize(list);
        }
        return String.valueOf(list);
    }

    public static String serialize(List<org.jdom2.Element> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<list-container>");
        for (org.jdom2.Element element : list) {
            stringBuffer.append(JDOMUtil.serialize(element));
        }
        stringBuffer.append("</list-container>");
        return stringBuffer.toString();
    }

    public static String serialize(Document document) {
        if (document != null) {
            try {
                XMLOutputter xMLOutputter = new XMLOutputter();
                xMLOutputter.getFormat().setOmitDeclaration(true);
                StringWriter stringWriter = new StringWriter();
                xMLOutputter.output(document, (Writer)stringWriter);
                stringWriter.close();
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                logger.error("error serializing document [" + String.valueOf(document) + "]", iOException);
                return null;
            }
        }
        return null;
    }

    public static String serializeFormat(org.jdom2.Element element) throws Exception {
        XMLOutputter xMLOutputter = new XMLOutputter();
        Format format = xMLOutputter.getFormat();
        format.setIndent("\t");
        format.setLineSeparator(System.getProperty("line.separator"));
        xMLOutputter.setFormat(format);
        StringWriter stringWriter = new StringWriter();
        xMLOutputter.output(element, (Writer)stringWriter);
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String serialize(org.jdom2.Element element) {
        if (element != null) {
            try {
                XMLOutputter xMLOutputter = new XMLOutputter();
                xMLOutputter.getFormat().setOmitDeclaration(true);
                StringWriter stringWriter = new StringWriter();
                xMLOutputter.output(element, (Writer)stringWriter);
                stringWriter.close();
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                logger.error("error serializing element [" + String.valueOf(element) + "]", iOException);
                return null;
            }
        }
        return null;
    }

    public static Set<String> getChildTags(org.jdom2.Element element) {
        HashSet<String> hashSet = new HashSet<String>();
        for (org.jdom2.Element element2 : element.getChildren()) {
            hashSet.add(element2.getName());
        }
        return hashSet;
    }

    public static void localizeElement(org.jdom2.Element element) {
        element.setNamespace(Namespace.NO_NAMESPACE);
        for (org.jdom2.Element element2 : element.getChildren()) {
            JDOMUtil.localizeElement(element2);
        }
    }
}

