/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.xml.JDOMStreamWriter;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.ActivitySchema;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import javax.xml.stream.XMLStreamWriter;
import org.jdom2.Element;

public class GenApiScript {
    private static final String classRoot = "commvault.cte.workflow.web";
    private File templateLocation;
    private String activityTemplate;
    private StringBuffer bActivities = new StringBuffer();
    private XMLStream stream = new XMLStream();

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        if (stringArray.length > 0) {
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            string2 = "C:\\Release11\\vaultcx\\Source\\CommServer\\CVWorkflowEngine";
            string = "c:\\temp";
        }
        GenApiScript genApiScript = new GenApiScript(string2);
        genApiScript.parse();
        genApiScript.writeFiles(string);
    }

    public GenApiScript(String string) throws Exception {
        this.templateLocation = new File(string, "resource\\commvault\\cte\\workflow\\api");
        this.activityTemplate = WorkflowUtils.readFile(new File(this.templateLocation, "sql_template.txt"));
    }

    private void parse() throws Exception {
        File file = new File(this.templateLocation, "ApiMapping.lst");
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine().trim();
            if (string.length() <= 0) continue;
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            String[] stringArray2 = string3.split("\\.");
            String string4 = stringArray2[stringArray2.length - 2] + "_" + stringArray2[stringArray2.length - 1];
            Class<?> clazz = Class.forName("commvault.cte.workflow.web." + string4);
            this.processActivity(string2, clazz);
        }
        scanner.close();
    }

    private void processActivity(String string, Class<?> clazz) throws Exception {
        ActivitySchema activitySchema = this.stream.generateActivitySchema(clazz);
        JDOMStreamWriter jDOMStreamWriter = new JDOMStreamWriter();
        XMLEncoder.encode((Object)activitySchema, (XMLStreamWriter)jDOMStreamWriter);
        Element element = jDOMStreamWriter.getDocument().getRootElement();
        element.setName("activitySchema");
        String string2 = String.format(this.activityTemplate, this.getSqlWrapper(string), this.getSqlWrapper(string), this.getSqlWrapper(""), this.getSqlWrapper(clazz.getName()), this.getSqlWrapper(JDOMUtil.serialize(element)), this.getSqlWrapper(clazz.getPackage().getName()));
        this.bActivities.append(string2);
    }

    private String getSqlWrapper(String string) {
        if (string == null) {
            return "null";
        }
        return "'" + this.formatSql(string) + "'";
    }

    private String formatSql(String string) {
        return string.replaceAll("'", "''");
    }

    private void writeFiles(String string) throws Exception {
        this.writeActivities(string);
    }

    private void writeActivities(String string) throws Exception {
        FileWriter fileWriter = new FileWriter(new File(string, "WF_ApiActivities.script"));
        fileWriter.write(this.bActivities.toString());
        fileWriter.close();
    }
}

