/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.stream.FieldType;
import commvault.msgs.Workflow.DebugActivity;
import commvault.msgs.Workflow.DebugWorkflowResp;
import commvault.msgs.Workflow.InteractiveResponse;
import commvault.msgs.Workflow.StepFlags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DebugHelper {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DebugHelper.class);

    public static DebugWorkflowResp buildWorkflowResponse(WorkflowContext workflowContext) throws Exception {
        DebugWorkflowResp debugWorkflowResp = new DebugWorkflowResp();
        DebugHelper.populateWorkflowResponse(debugWorkflowResp, workflowContext);
        RequestManager.populateInteractiveResponse((InteractiveResponse)debugWorkflowResp, workflowContext);
        List<WF_ProcessSteps_t> list = workflowContext.getDataAccess().getProcessSteps(workflowContext.getJobId(), null, null);
        List<DebugActivity> list2 = DebugHelper.getActivities(workflowContext.getDataAccess(), list);
        debugWorkflowResp.setActivities(list2);
        return debugWorkflowResp;
    }

    public static DebugWorkflowResp buildThreadResponse(ActivityContext activityContext) throws Exception {
        DebugWorkflowResp debugWorkflowResp = new DebugWorkflowResp();
        DebugHelper.buildThreadResponse(debugWorkflowResp, activityContext);
        return debugWorkflowResp;
    }

    public static void buildThreadResponse(DebugWorkflowResp debugWorkflowResp, ActivityContext activityContext) throws Exception {
        DebugHelper.populateWorkflowResponse(debugWorkflowResp, activityContext);
        RequestManager.populateInteractiveResponse((InteractiveResponse)debugWorkflowResp, activityContext);
        List<WF_ProcessSteps_t> list = activityContext.getDataAccess().getActivitiesForContext(activityContext.getContext().getId());
        List<DebugActivity> list2 = DebugHelper.getActivities(activityContext.getDataAccess(), list);
        debugWorkflowResp.setActivities(list2);
        DebugHelper.populateDynamicData(debugWorkflowResp, activityContext, list2);
        debugWorkflowResp.setBreakpoint(activityContext.getUniqueName());
        if (activityContext.getTransitions().length > 0) {
            if (activityContext.isForkTransitions()) {
                for (WorkflowTransition workflowTransition : activityContext.getTransitions()) {
                    debugWorkflowResp.getTransitions().add(workflowTransition.getTargetActivity());
                }
            } else {
                debugWorkflowResp.getTransitions().add(activityContext.getTransitions()[0].getTargetActivity());
            }
        }
    }

    private static void populateWorkflowResponse(DebugWorkflowResp debugWorkflowResp, WorkflowContext workflowContext) {
        debugWorkflowResp.setWorkflowInputs(workflowContext.getWorkflowExecution().serialiazeInputs());
        debugWorkflowResp.setWorkflowVariables(workflowContext.getWorkflowExecution().serialiazeVariables());
        debugWorkflowResp.setWorkflowSystem(workflowContext.getWorkflowExecution().serialiazeSystem());
        if (workflowContext instanceof WorkflowProcess) {
            debugWorkflowResp.setWorkflowOutputs(((WorkflowProcess)workflowContext).getOutputs());
        }
        debugWorkflowResp.setStatus(workflowContext.getWorkflowStatus().toInt());
        debugWorkflowResp.setDebugLog(workflowContext.getDebugLog());
    }

    private static List<DebugActivity> getActivities(DataAccessLayer dataAccessLayer, List<WF_ProcessSteps_t> list) throws Exception {
        Object object;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
            object = new DebugActivity();
            object.setUniqueName(wF_ProcessSteps_t.Name.get());
            object.setProcessStepId(wF_ProcessSteps_t.ProcessStepId.getIntValue());
            object.setInputs(wF_ProcessSteps_t.Inputs.getString());
            object.setOutputs(wF_ProcessSteps_t.Outputs.getString());
            object.setStatus(wF_ProcessSteps_t.Status.get().intValue());
            object.setRestarts(wF_ProcessSteps_t.Restarts.getIntValue());
            object.setAttempts(wF_ProcessSteps_t.Attempts.getIntValue());
            object.setState(wF_ProcessSteps_t.State.getIntValue());
            object.setStartTime(wF_ProcessSteps_t.StartTime.getIntValue());
            object.setEndTime(wF_ProcessSteps_t.EndTime.getIntValue());
            object.setTrackingId(wF_ProcessSteps_t.subJobId.getLongValue().intValue());
            object.setCommented((wF_ProcessSteps_t.flags.getIntValue() & StepFlags.COMMENTED.getEnumValue()) > 0);
            object.getFailureReason().add(wF_ProcessSteps_t.failureReason.get());
            hashMap.put(wF_ProcessSteps_t.ProcessStepId.get(), object);
        }
        block1: for (WF_ProcessSteps_t wF_ProcessSteps_t : hashMap.values()) {
            object = dataAccessLayer.getTargetTransition(wF_ProcessSteps_t.getProcessStepId());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                WF_ProcessTransitions_t wF_ProcessTransitions_t = (WF_ProcessTransitions_t)((Object)iterator.next());
                DebugActivity debugActivity = (DebugActivity)hashMap.get(wF_ProcessTransitions_t.TargetProcessStepId.get());
                if (debugActivity == null) continue;
                wF_ProcessSteps_t.setTransitionTo(debugActivity.getUniqueName());
                continue block1;
            }
        }
        return new ArrayList<DebugActivity>(hashMap.values());
    }

    private static void populateDynamicData(DebugWorkflowResp debugWorkflowResp, ActivityContext activityContext, List<DebugActivity> list) throws EvFailureException {
        for (WorkflowElement object : activityContext.getParent().getProcessXml()) {
            if (object == null || object.getName() == null) continue;
            for (Object object2 : debugWorkflowResp.getActivities()) {
                if (!object.getName().equals(object2.getUniqueName())) continue;
                object2.setOutputs(object.toString());
            }
        }
        Object object = activityContext.getParent();
        while (!object.isRoot()) {
            if (object.getMaskedStep() != null && object.getMaskedStep().length() > 0) {
                for (DebugActivity debugActivity : list) {
                    Object object2;
                    if (debugActivity.getProcessStepId() != object.getProcessStepId().intValue()) continue;
                    object2 = new WorkflowElement(activityContext.getUniqueName());
                    activityContext.getMarshaller().marshal(activityContext.getActivity(), (WorkflowElement)object2, FieldType.INPUTS);
                    DebugActivity debugActivity2 = new DebugActivity();
                    debugActivity2.setUniqueName(object.getMaskedStep());
                    debugActivity2.setProcessStepId(debugActivity.getProcessStepId());
                    debugActivity2.setInputs(((WorkflowElement)object2).toString());
                    debugActivity2.setOutputs(debugActivity.getOutputs());
                    debugActivity2.setStatus(debugActivity.getStatus());
                    debugActivity2.setRestarts(debugActivity.getRestarts());
                    debugActivity2.setAttempts(debugActivity.getAttempts());
                    debugActivity2.setState(debugActivity.getState());
                    debugActivity2.setStartTime(debugActivity.getStartTime());
                    debugActivity2.setEndTime(debugActivity.getEndTime());
                    debugActivity2.setTrackingId(debugActivity.getTrackingId());
                    debugActivity2.setCommented(debugActivity.getCommented());
                    debugActivity2.setFailureReason(debugActivity2.getFailureReason());
                    list.add(debugActivity2);
                    break;
                }
            }
            object = object.getParent();
        }
    }
}

