/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.SingleValueConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import workflow.types.Time;

public class TimeConverter
extends SingleValueConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(TimeConverter.class);
    private static final String[] TIME_FORMATS = new String[]{"HH:mm:ssZ", "HH:mm:ss"};

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(Time.class);
    }

    @Override
    public Object fromString(String string) {
        if (string != null && string.length() > 0) {
            Date date;
            if (NumberUtils.isDigits((String)string)) {
                try {
                    return new Time(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error("failed to parse epoc time [" + string + "]", numberFormatException);
                }
            }
            try {
                date = DateUtils.parseDate((String)string, (String[])TIME_FORMATS);
            }
            catch (ParseException parseException) {
                logger.error("failed to parse time [" + string + "], acceptable formats %s" + Arrays.asList(TIME_FORMATS));
                throw new Error(parseException);
            }
            return new Time(date);
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        Time time = (Time)object;
        return DateFormatUtils.format((Date)time.getDate(), (String)"HH:mm:ssZ");
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema(Time.class);
    }
}

