/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.stream.CollectionConverter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PropertiesConverter
extends CollectionConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(Properties.class);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Properties properties = new Properties();
        for (WorkflowElement workflowElement : unmarshallingContext.getElementHolder().getElements()) {
            String string = workflowElement.getAttributeValue("_nil_");
            if (string != null && Boolean.valueOf(string).booleanValue()) continue;
            properties.put(workflowElement.getAttributeValue("name"), workflowElement.getAttributeValue("value"));
        }
        return properties;
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        Vector<WorkflowElement> vector = new Vector<WorkflowElement>();
        Properties properties = (Properties)marshallingContext.getSource();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            WorkflowElement workflowElement = new WorkflowElement(marshallingContext.getElementName());
            workflowElement.setAttribute("class", marshallingContext.getSource().getClass().getName());
            workflowElement.setAttribute("name", String.valueOf(entry.getKey()));
            workflowElement.setAttribute("value", String.valueOf(entry.getValue()));
            vector.add(workflowElement);
        }
        return new GroupedElements(vector);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        XMLSchema xMLSchema = SchemaUtils.getSchema(Properties.class);
        xMLSchema.setListType(true);
        XMLSchema xMLSchema2 = SchemaUtils.getSchema(String.class);
        xMLSchema2.setName("name");
        xMLSchema2.setAttribute(true);
        xMLSchema.getChildren().add(xMLSchema2);
        XMLSchema xMLSchema3 = SchemaUtils.getSchema(String.class);
        xMLSchema3.setName("value");
        xMLSchema3.setAttribute(true);
        xMLSchema.getChildren().add(xMLSchema3);
        return xMLSchema;
    }
}

