/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.AbstractConverter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class MapConverter
extends AbstractConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MapConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Map map;
        ObjectType objectType = new ObjectType((Type)((Object)Object.class));
        ObjectType objectType2 = new ObjectType((Type)((Object)Object.class));
        if (unmarshallingContext.getType().getParameters().size() > 0) {
            objectType = unmarshallingContext.getType().getParameters().get(0);
            objectType2 = unmarshallingContext.getType().getParameters().get(1);
        }
        Class clazz = unmarshallingContext.getType().isInterface() ? XMLStream.DEFAULT_MAP_CLASS : unmarshallingContext.getType().getRawType();
        try {
            map = (Map)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + clazz + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        for (WorkflowElement workflowElement : unmarshallingContext.getElementHolder().getElement().getChildren("entry")) {
            String string = workflowElement.getAttributeValue("_nil_");
            if (string != null && Boolean.valueOf(string).booleanValue()) continue;
            Object object = this.buildValue(unmarshallingContext, workflowElement.getChildren("key"), objectType);
            Object object2 = this.buildValue(unmarshallingContext, workflowElement.getChildren("value"), objectType2);
            map.put(object, object2);
        }
        return map;
    }

    private Object buildValue(XMLStream.UnmarshallingContext unmarshallingContext, List<WorkflowElement> list, ObjectType objectType) throws EvFailureException {
        if (list.size() > 0) {
            return unmarshallingContext.unmarshalAnother(objectType, new GroupedElements(list));
        }
        return null;
    }

    @Override
    public void write(XMLStream.MarshallingContext marshallingContext, WorkflowElement workflowElement) throws EvFailureException {
        Map map = (Map)marshallingContext.getSource();
        for (Map.Entry entry : map.entrySet()) {
            ElementHolder elementHolder;
            WorkflowElement workflowElement2 = new WorkflowElement("entry");
            workflowElement2.setAttribute("class", entry.getClass().getName());
            workflowElement.addContent(workflowElement2);
            ElementHolder elementHolder2 = marshallingContext.marshalAnother("key", entry.getKey());
            if (elementHolder2 != null) {
                workflowElement2.addContent(elementHolder2.getElements());
            }
            if ((elementHolder = marshallingContext.marshalAnother("value", entry.getValue())) == null) continue;
            workflowElement2.addContent(elementHolder.getElements());
        }
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        Object object;
        Object object2;
        XMLSchema xMLSchema;
        ParameterizedType parameterizedType;
        XMLSchema xMLSchema2 = SchemaUtils.getSchema((Class)schemaContext.getFieldClass());
        if (schemaContext.getFieldType() instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)schemaContext.getFieldType();
            xMLSchema = parameterizedType.getActualTypeArguments();
            object2 = xMLSchema[0];
            object = xMLSchema[1];
        } else {
            object2 = Object.class;
            object = Object.class;
        }
        Object object3 = object2 instanceof ParameterizedType ? (Class)((ParameterizedType)object2).getRawType() : object2;
        Object object4 = object instanceof ParameterizedType ? (Class)((ParameterizedType)object).getRawType() : object;
        parameterizedType = SchemaUtils.getSchema(Map.Entry.class);
        parameterizedType.setName("entry");
        parameterizedType.setListType(true);
        xMLSchema2.getChildren().add(parameterizedType);
        parameterizedType.setParent(xMLSchema2);
        xMLSchema = schemaContext.generateAnother((XMLSchema)parameterizedType, (Class)object3, (Type)object2);
        xMLSchema.setName("key");
        parameterizedType.getChildren().add(xMLSchema);
        xMLSchema.setParent((XMLSchema)parameterizedType);
        XMLSchema xMLSchema3 = schemaContext.generateAnother((XMLSchema)parameterizedType, (Class)object4, (Type)object);
        xMLSchema3.setName("value");
        parameterizedType.getChildren().add(xMLSchema3);
        xMLSchema3.setParent((XMLSchema)parameterizedType);
        return xMLSchema2;
    }
}

