/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.SingleValueConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import commvault.qnet.sys.CVPassword;
import workflow.types.EncryptedString;

public class EncryptedStringConverter
extends SingleValueConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EncryptedStringConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(EncryptedString.class);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        WorkflowElement workflowElement = unmarshallingContext.getElementHolder().getElement();
        String string = workflowElement.getAttributeValue("_nil_");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            return null;
        }
        String string2 = workflowElement.getAttributeValue("class");
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (clazz.equals(String.class)) {
                    CVPassword cVPassword = new CVPassword();
                    return new EncryptedString(cVPassword.encrypt(workflowElement.getText()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("failed to instantiate type [" + string2 + "] to convert to EncryptedString", classNotFoundException);
            }
        } else {
            logger.xml("source element [%s] does not contain a type", workflowElement.getName());
        }
        return this.fromString(workflowElement.getText());
    }

    @Override
    public Object fromString(String string) {
        return new EncryptedString(string);
    }

    @Override
    public String toString(Object object) {
        return ((EncryptedString)object).toString();
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema(EncryptedString.class);
    }
}

