/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.Converter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import workflow.types.XML;

public class ElementConverter
implements Converter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ElementConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return XML.class.isAssignableFrom(clazz);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        return unmarshallingContext.getElementHolder().getElement();
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        WorkflowElement workflowElement;
        if (marshallingContext.getSource() instanceof WorkflowElement) {
            workflowElement = ((WorkflowElement)marshallingContext.getSource()).clone();
            workflowElement.setName(marshallingContext.getElementName());
        } else {
            workflowElement = new WorkflowElement(marshallingContext.getElementName());
            workflowElement.setText(((XML)marshallingContext.getSource()).getText());
        }
        workflowElement.setAttribute("_list_", Boolean.FALSE.toString());
        return new SingleElement(workflowElement);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema((Class)schemaContext.getFieldClass());
    }
}

