/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.SingleValueConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class DurationConverter
extends SingleValueConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DurationConverter.class);
    private DatatypeFactory factory;

    public DurationConverter() {
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            logger.error("error loading DatatypeFactory", datatypeConfigurationException);
            this.factory = null;
        }
    }

    @Override
    public boolean canConvert(Class clazz) {
        return this.factory != null && Duration.class.isAssignableFrom(clazz);
    }

    @Override
    public Object fromString(String string) {
        return this.factory.newDuration(string);
    }
}

