/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.WorkflowSchema;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.SingleValueConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.XDate;
import commvault.msgs.App.XMLSchema;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class DateConverter
extends SingleValueConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DateConverter.class);
    private final String[] acceptableFormats;

    public DateConverter() {
        this(WorkflowSchema.DEFAULT_DATE_FORMATS);
    }

    public DateConverter(String[] stringArray) {
        this.acceptableFormats = stringArray;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    @Override
    public Object fromString(String string) {
        Date date;
        if (string.length() == 0) {
            return null;
        }
        if (NumberUtils.isDigits((String)string)) {
            try {
                return new Date(Long.valueOf(string) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("failed to parse epoc time [" + string + "]", numberFormatException);
            }
        }
        try {
            date = DateUtils.parseDate((String)string, (String[])this.acceptableFormats);
        }
        catch (ParseException parseException) {
            logger.error("failed to parse date [" + string + "], acceptable formats " + Arrays.asList(this.acceptableFormats));
            throw new Error(parseException);
        }
        return new XDate(date.getTime());
    }

    @Override
    public String toString(Object object) {
        return DateFormatUtils.format((Date)((Date)object), (String)"yyyy-MM-dd");
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema(Date.class);
    }
}

