/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.annotations.XmlField;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.Container;
import commvault.cte.workflow.stream.ObjectType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StreamField {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(StreamField.class);
    private final Field field;
    private final ObjectType type;
    private Method getter;
    private Method setter;
    private String elementName;
    private Container parent;

    public StreamField(Container container, Field field) {
        this.field = field;
        this.field.setAccessible(true);
        this.parent = container;
        this.type = new ObjectType(field.getType(), field.getGenericType());
        if (field.getAnnotation(XmlField.class) != null && field.getAnnotation(XmlField.class).name() != null && field.getAnnotation(XmlField.class).name().length() > 0) {
            this.elementName = field.getAnnotation(XmlField.class).name();
        }
        if (this.elementName == null) {
            this.elementName = field.getName();
        }
        String string = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            this.getter = this.parent.getSource().getClass().getMethod("get" + string, null);
            if (!this.getter.getReturnType().equals(field.getType())) {
                this.getter = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setter = this.parent.getSource().getClass().getMethod("set" + string, field.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getName() {
        return this.field.getName();
    }

    public void set(Object object) throws EvFailureException {
        if (this.field.getType().isPrimitive() && object == null) {
            logger.warn("cannot set a null value on field [%s], class [%s] which is of primitive type [%s]", this.field.getName(), this.parent.getType().getName(), this.field.getType().getName());
        } else {
            try {
                if (this.setter != null) {
                    this.setter.invoke(this.parent.getSource(), object);
                } else {
                    this.field.set(this.parent.getSource(), object);
                }
            }
            catch (Exception exception) {
                logger.error("failed to set field [" + this.field.getName() + "], class [" + this.parent.getType().getName() + "], value [" + String.valueOf(object) + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
    }

    public Object get() throws EvFailureException {
        try {
            if (this.getter != null) {
                return this.getter.invoke(this.parent.getSource(), new Object[0]);
            }
            return this.field.get(this.parent.getSource());
        }
        catch (Exception exception) {
            logger.error("failed to get field [" + this.field.getName() + "], class [" + this.parent.getType().getName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    public ObjectType getType() {
        return this.type;
    }
}

