/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ObjectType {
    private Class clazz;
    private Type type;
    private final List<ObjectType> parameters = new ArrayList<ObjectType>();

    public ObjectType(Class clazz, Type type) {
        this.clazz = clazz;
        this.type = type;
        this.buildParameterizedList();
    }

    public ObjectType(Type type) {
        if (type instanceof ParameterizedType) {
            this.type = type;
            this.clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            if (type instanceof Class) {
                this.clazz = (Class)type;
            }
            this.type = type;
        }
        this.buildParameterizedList();
    }

    private void buildParameterizedList() {
        if (this.type instanceof ParameterizedType) {
            Type[] typeArray;
            for (Type type : typeArray = ((ParameterizedType)this.type).getActualTypeArguments()) {
                this.parameters.add(new ObjectType(type));
            }
        }
    }

    public Class getRawType() {
        return this.clazz;
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.clazz.newInstance();
    }

    public Class getComponentType() {
        return this.clazz.getComponentType();
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean isObject() {
        return this.clazz.equals(Object.class);
    }

    public List<ObjectType> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.clazz.toString();
    }
}

