/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.stream.Container;
import commvault.cte.workflow.stream.StreamField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class MessageContainer
implements Container {
    private List<StreamField> fields = new ArrayList<StreamField>();
    private final Object source;

    public MessageContainer(Object object) {
        this.source = object;
        this.buildFields(object.getClass());
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Class getType() {
        return this.source.getClass();
    }

    @Override
    public boolean hasFields() {
        return this.fields.size() > 0;
    }

    private void buildFields(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getModifiers() != 4) continue;
            this.fields.add(new StreamField(this, field));
        }
        Class clazz2 = clazz.getSuperclass();
        if (!clazz2.equals(CTEProcessingModel.class)) {
            this.buildFields(clazz2);
        }
    }

    @Override
    public StreamField[] getOutputFields() {
        return this.getFields();
    }

    @Override
    public StreamField[] getInputFields() {
        return this.getFields();
    }

    @Override
    public StreamField[] getFields() {
        return this.fields.toArray(new StreamField[0]);
    }

    @Override
    public StreamField getFieldByElementName(String string) {
        for (StreamField streamField : this.fields) {
            if (!streamField.getElementName().equals(string)) continue;
            return streamField;
        }
        return null;
    }
}

