/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.stream.ElementHolder;
import java.util.ArrayList;
import java.util.List;

public class GroupedElements
implements ElementHolder {
    private List<WorkflowElement> elements;

    public GroupedElements() {
        this.elements = new ArrayList<WorkflowElement>();
    }

    public GroupedElements(WorkflowElement workflowElement) {
        this.elements = new ArrayList<WorkflowElement>();
        this.elements.add(workflowElement);
    }

    public GroupedElements(List<WorkflowElement> list) {
        this.elements = list;
    }

    @Override
    public WorkflowElement getElement() {
        return this.elements.get(0);
    }

    @Override
    public List<WorkflowElement> getElements() {
        return this.elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isList() {
        return this.elements.size() > 1 || this.isDefaultList();
    }

    @Override
    public WorkflowElement getXml() {
        if (this.elements.size() > 0) {
            if (this.elements.size() == 1) {
                return this.getElement();
            }
            WorkflowElement workflowElement = new WorkflowElement("list-container");
            workflowElement.cloneContent(this.elements);
            return workflowElement;
        }
        return null;
    }

    private boolean isDefaultList() {
        return Boolean.parseBoolean(this.getElement().getAttributeValue("_list_"));
    }

    @Override
    public Class getType() {
        if (this.elements.size() == 0) {
            return null;
        }
        String string = this.getElement().getAttributeValue("class");
        if (string != null) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException);
            }
        }
        return Object.class;
    }
}

