/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.workflow.stream.Container;
import commvault.cte.workflow.stream.StreamField;
import commvault.cte.workflow.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ClassContainer
implements Container {
    private List<StreamField> fields = new ArrayList<StreamField>();
    private final Object source;

    public ClassContainer(Object object) {
        this.source = object;
        this.buildFields(object.getClass());
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Class getType() {
        return this.source.getClass();
    }

    @Override
    public boolean hasFields() {
        return this.fields.size() > 0;
    }

    private void buildFields(Class clazz) {
        List<Field> list = ReflectionUtils.getAccessibleFields(clazz, true);
        for (Field field : list) {
            this.fields.add(new StreamField(this, field));
        }
    }

    @Override
    public StreamField[] getOutputFields() {
        ArrayList<StreamField> arrayList = new ArrayList<StreamField>();
        for (StreamField streamField : this.fields) {
            if (!ReflectionUtils.isOutputField(streamField.getField()) && !ReflectionUtils.isInternalField(streamField.getField())) continue;
            arrayList.add(streamField);
        }
        return arrayList.toArray(new StreamField[0]);
    }

    @Override
    public StreamField[] getInputFields() {
        ArrayList<StreamField> arrayList = new ArrayList<StreamField>();
        for (StreamField streamField : this.fields) {
            if (!ReflectionUtils.isInputField(streamField.getField())) continue;
            arrayList.add(streamField);
        }
        return arrayList.toArray(new StreamField[0]);
    }

    @Override
    public StreamField[] getFields() {
        return this.fields.toArray(new StreamField[0]);
    }

    @Override
    public StreamField getFieldByElementName(String string) {
        for (StreamField streamField : this.fields) {
            if (!streamField.getElementName().equals(string)) continue;
            return streamField;
        }
        return null;
    }
}

