/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.schema;

import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBTimestamp;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.db.cs.WF_Schema_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaLock;
import commvault.cte.workflow.utils.JDOMUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SchemaManager
extends SchemaTypeSystem {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SchemaManager.class);
    private final List<SchemaContainer> schemaRows = new ArrayList<SchemaContainer>();
    private SchemaLock lock;

    public static SchemaManager newInstance() throws EvFailureException {
        List<WF_Schema_t> list;
        SchemaLock schemaLock;
        logger.debug("trying to gain lock on global workflow schema");
        try {
            schemaLock = SchemaLock.getLock();
        }
        catch (Exception exception) {
            logger.error("failed to acquire lock on schema table", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_GLOBAL_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        logger.debug("retrieved lock on global workflow schema");
        try {
            list = WF_Schema_t.select();
        }
        catch (CTEDBException cTEDBException) {
            schemaLock.close();
            logger.error("failed to retrieve schema rows", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_GLOBAL_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Object object : list) {
            try {
                Element element = JDOMUtil.parseXml(object.XsdSchema.get());
                if (element == null) continue;
                arrayList.add(element);
            }
            catch (JDOMException jDOMException) {
                schemaLock.close();
                logger.error("failed to parse schema xml [" + object.XsdSchema.get() + "]", jDOMException);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_GLOBAL_SCHEMA", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        try {
            return new SchemaManager(schemaLock, list, arrayList.toArray(new Element[0]));
        }
        catch (Exception exception) {
            Object object;
            schemaLock.close();
            logger.error("failed to initialize schema manager", exception);
            object = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_GLOBAL_SCHEMA", new Object[0]);
            throw new EvFailureException((EvMessageContainer)object);
        }
    }

    private SchemaManager(SchemaLock schemaLock, List<WF_Schema_t> list, Element[] elementArray) throws Exception {
        super(elementArray);
        this.lock = schemaLock;
        for (WF_Schema_t wF_Schema_t : list) {
            this.schemaRows.add(new SchemaContainer(wF_Schema_t));
        }
    }

    public SchemaDocument createSchema(String string, int n) throws Exception {
        SchemaDocument schemaDocument = super.createSchema(string, string);
        this.add(schemaDocument, n);
        return schemaDocument;
    }

    public SchemaDocument createSchema(String string, WF_SchemaLocation_t wF_SchemaLocation_t) throws Exception {
        return this.createSchema(string, wF_SchemaLocation_t.LocationId.get());
    }

    public SchemaDocument[] importSchema(SchemaTypeSystem schemaTypeSystem, WF_SchemaLocation_t wF_SchemaLocation_t) throws Exception {
        SchemaDocument[] schemaDocumentArray;
        for (SchemaDocument schemaDocument : schemaDocumentArray = super.importSchema(schemaTypeSystem)) {
            this.add(schemaDocument, wF_SchemaLocation_t.LocationId.get());
        }
        return schemaDocumentArray;
    }

    private void add(SchemaDocument schemaDocument, int n) throws Exception {
        Integer n2 = this.getSchemaId(schemaDocument.getTargetNamespace());
        if (n2 == null || n2 <= 0) {
            WF_Schema_t wF_Schema_t = new WF_Schema_t();
            wF_Schema_t.Namespace.set(schemaDocument.getTargetNamespace());
            wF_Schema_t.LocationId.set(Integer.valueOf(n));
            SchemaContainer schemaContainer = new SchemaContainer(wF_Schema_t);
            schemaContainer.save();
            this.schemaRows.add(schemaContainer);
        }
    }

    public void save() throws EvFailureException {
        for (SchemaContainer schemaContainer : this.schemaRows) {
            schemaContainer.save();
        }
    }

    public void close() {
        logger.debug("releasing lock on global workflow schema");
        this.lock.close();
    }

    public WF_Schema_t getSchemaRow(int n) {
        for (SchemaContainer schemaContainer : this.schemaRows) {
            if (((SchemaContainer)schemaContainer).schemaRow.SchemaId.get() != n) continue;
            return schemaContainer.schemaRow;
        }
        return null;
    }

    public WF_Schema_t getSchemaRow(String string) {
        for (SchemaContainer schemaContainer : this.schemaRows) {
            if (!((SchemaContainer)schemaContainer).schemaRow.Namespace.get().equals(string)) continue;
            return schemaContainer.schemaRow;
        }
        return null;
    }

    public String getNamespace(int n) {
        for (SchemaContainer schemaContainer : this.schemaRows) {
            if (((SchemaContainer)schemaContainer).schemaRow.SchemaId.get() != n) continue;
            return ((SchemaContainer)schemaContainer).schemaRow.Namespace.get();
        }
        return null;
    }

    public Integer getSchemaId(String string) {
        for (SchemaContainer schemaContainer : this.schemaRows) {
            if (!((SchemaContainer)schemaContainer).schemaRow.Namespace.get().equals(string)) continue;
            return ((SchemaContainer)schemaContainer).schemaRow.SchemaId.get();
        }
        return null;
    }

    public boolean removeLocation(int n) throws CTEDBException {
        WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
        String string = String.format("LocationId = %s", n);
        if (!wF_SchemaLocation_t.fill(string)) {
            return false;
        }
        return wF_SchemaLocation_t.delete();
    }

    public class SchemaContainer {
        private final WF_Schema_t schemaRow;

        public SchemaContainer(WF_Schema_t wF_Schema_t) {
            this.schemaRow = wF_Schema_t;
        }

        public void save() throws EvFailureException {
            SchemaDocument schemaDocument = SchemaManager.this.getNamespace(this.schemaRow.Namespace.get());
            if (schemaDocument == null) {
                logger.info("did not find w3c generated schema for namespace [%s]", this.schemaRow.Namespace.get());
                this.schemaRow.XsdSchema.set("");
            } else {
                String string;
                try {
                    string = JDOMUtil.serializeXml(schemaDocument.getSchema());
                }
                catch (IOException iOException) {
                    logger.error("failed to serialize schema xml for namespace [" + this.schemaRow.Namespace.get() + "]", iOException);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_SCHEMA", this.schemaRow.Namespace.get());
                    throw new EvFailureException(evMessageContainer);
                }
                if (string == null) {
                    logger.info("no W3C schema generated for namespace [%s]", this.schemaRow.Namespace.get());
                    this.schemaRow.XsdSchema.set("");
                } else {
                    this.schemaRow.XsdSchema.set(string);
                }
            }
            this.schemaRow.Modified.set(CTEDBTimestamp.getNow());
            try {
                this.schemaRow.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to save schema [" + this.schemaRow.Namespace.get() + "]", cTEDBException);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_SCHEMA", this.schemaRow.Namespace.get());
                throw new EvFailureException(evMessageContainer);
            }
        }
    }
}

