/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.PackageImporter;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestHandler;
import commvault.cte.workflow.message.RequestManager;
import commvault.msgs.Workflow.RefreshSchemaLocationRequest;
import commvault.msgs.Workflow.SchemaLocationType;
import commvault.msgs.Workflow.WorkflowRequest;

public class RefreshLocationRequestHandler
implements RequestHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RefreshLocationRequestHandler.class);

    private CTEProcessingModel handle(WorkflowRequest workflowRequest) throws EvFailureException {
        RefreshSchemaLocationRequest refreshSchemaLocationRequest = (RefreshSchemaLocationRequest)workflowRequest;
        WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
        String string = String.format("LocationId = %s", refreshSchemaLocationRequest.getSchemaLocation().getSchemaLocationId());
        try {
            logger.debug("retrieving location [%s]", refreshSchemaLocationRequest.getSchemaLocation().getSchemaLocationUrl());
            if (!wF_SchemaLocation_t.fill(string)) {
                logger.error("could not retrieve location id [" + refreshSchemaLocationRequest.getSchemaLocation().getSchemaLocationId() + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_REFRESH_IMPORT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error retrieving location id [" + refreshSchemaLocationRequest.getSchemaLocation().getSchemaLocationId() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_REFRESH_IMPORT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (wF_SchemaLocation_t.LocationType.get().intValue() != SchemaLocationType.JAR.getEnumValue() && wF_SchemaLocation_t.LocationType.get().intValue() != SchemaLocationType.INTERNAL.getEnumValue()) {
            logger.error("cannot refresh schema location type [" + wF_SchemaLocation_t.LocationType.get() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_REFRESH_IMPORT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        PackageImporter.refresh(wF_SchemaLocation_t, workflowRequest.getProcessingInstructionInfo().getUser());
        return RequestManager.getGenericResponse();
    }

    @Override
    public void handle(WorkflowRequest workflowRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        asyncWorkflowResponse.setResponse(this.handle(workflowRequest));
    }
}

