/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestHandler;
import commvault.cte.workflow.message.RequestManager;
import commvault.msgs.Workflow.WorkflowJobControl;
import commvault.msgs.Workflow.WorkflowRequest;

public class JobControlHandler
implements RequestHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JobControlHandler.class);

    private CTEProcessingModel handle(WorkflowRequest workflowRequest) throws EvFailureException {
        WorkflowJobControl workflowJobControl = (WorkflowJobControl)workflowRequest;
        switch (workflowJobControl.getOperation()) {
            case RESUME: {
                if (workflowJobControl.getControlAll()) {
                    WorkflowEngine.getInstance().resumeAll(workflowRequest.getProcessingInstructionInfo().getUser());
                    break;
                }
                WorkflowEngine.getInstance().resume(workflowJobControl.getJobId(), workflowJobControl.getCommCell().getCommCellId(), workflowRequest.getProcessingInstructionInfo().getUser());
                break;
            }
            case KILL: {
                if (workflowJobControl.getControlAll()) {
                    WorkflowEngine.getInstance().killAll(workflowRequest.getProcessingInstructionInfo().getUser(), workflowJobControl.getJobDescription());
                    break;
                }
                WorkflowEngine.getInstance().kill(workflowJobControl.getJobId(), workflowJobControl.getCommCell().getCommCellId(), workflowRequest.getProcessingInstructionInfo().getUser(), workflowJobControl.getJobDescription());
                break;
            }
            case SUSPEND: {
                if (workflowJobControl.getControlAll()) {
                    WorkflowEngine.getInstance().suspendAll(workflowRequest.getProcessingInstructionInfo().getUser(), workflowJobControl.getJobDescription(), workflowJobControl.getAutoResumeSeconds());
                    break;
                }
                WorkflowEngine.getInstance().suspend(workflowJobControl.getJobId(), workflowJobControl.getCommCell().getCommCellId(), workflowRequest.getProcessingInstructionInfo().getUser(), workflowJobControl.getJobDescription(), workflowJobControl.getAutoResumeSeconds());
                break;
            }
            default: {
                logger.error("job operation [" + String.valueOf(workflowJobControl.getOperation()) + "] not implemented");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INITIALIZE_REQUEST", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        return RequestManager.getGenericResponse();
    }

    @Override
    public void handle(WorkflowRequest workflowRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        asyncWorkflowResponse.setResponse(this.handle(workflowRequest));
    }
}

