/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowManager;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestHandler;
import commvault.msgs.Workflow.GetWorkflowExecutionReq;
import commvault.msgs.Workflow.GetWorkflowExecutionResp;
import commvault.msgs.Workflow.WorkflowExecution;
import commvault.msgs.Workflow.WorkflowRequest;
import java.util.List;

public class GetExecutionHandler
implements RequestHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(GetExecutionHandler.class);

    private CTEProcessingModel handle(WorkflowRequest workflowRequest) throws EvFailureException {
        GetWorkflowExecutionReq getWorkflowExecutionReq = (GetWorkflowExecutionReq)workflowRequest;
        if (getWorkflowExecutionReq.getCommCellId() == 0) {
            getWorkflowExecutionReq.setCommCellId(2);
        }
        GetWorkflowExecutionResp getWorkflowExecutionResp = new GetWorkflowExecutionResp();
        WorkflowManager workflowManager = WorkflowEngine.getInstance().getWorkflowManager(getWorkflowExecutionReq.getJobId(), getWorkflowExecutionReq.getCommCellId());
        getWorkflowExecutionResp.getExecution().getEntity().setWorkflowId(workflowManager.getWorkflow().getWorkflowId());
        getWorkflowExecutionResp.getExecution().getEntity().setWorkflowName(workflowManager.getWorkflow().getWorkflowName());
        getWorkflowExecutionResp.getExecution().setJobId(workflowManager.getWorkflow().getJobId());
        getWorkflowExecutionResp.getExecution().setCommCellId(workflowManager.getWorkflow().getCommCellId());
        getWorkflowExecutionResp.getExecution().setInputs(workflowManager.getWorkflow().getWorkflowExecution().getInputs().toString());
        getWorkflowExecutionResp.getExecution().setVariables(workflowManager.getWorkflow().getWorkflowExecution().getVariables().toString());
        getWorkflowExecutionResp.getExecution().setStatus(workflowManager.getWorkflow().getStatus().toInt());
        getWorkflowExecutionResp.getExecution().setVersion(workflowManager.getWorkflow().getVersion());
        if (workflowManager.getWorkflow().getStatus() == ProcessStatus.SUSPENDED) {
            List<WF_SuperProcess_t> list;
            try {
                list = WF_SuperProcess_t.select("State = 1 AND DeploymentId IS NOT NULL AND jobId = " + workflowManager.getJobId());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to retrieve embedded workflows for job id [" + workflowManager.getJobId() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            for (WF_SuperProcess_t wF_SuperProcess_t : list) {
                String string;
                WorkflowExecution workflowExecution = new WorkflowExecution();
                getWorkflowExecutionResp.getExecution().getChildren().add(workflowExecution);
                WorkflowElement workflowElement = WorkflowElement.parse(wF_SuperProcess_t.Execution.get());
                workflowElement.createDocument();
                try {
                    string = (String)workflowElement.getNode("string(/workflow/system/workflow/workflowId)");
                }
                catch (Exception exception) {
                    logger.error("failed to get elements for path /workflow/system/workflow/workflowId", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                workflowExecution.getEntity().setWorkflowId(Integer.valueOf(string).intValue());
                try {
                    workflowExecution.getEntity().setWorkflowName(String.valueOf(workflowElement.getNode("string(/workflow/system/workflow/workflowName)")));
                }
                catch (Exception exception) {
                    logger.error("failed to get elements for path /workflow/system/workflow/workflowName", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                workflowExecution.setProcessId(wF_SuperProcess_t.SuperProcessId.get().intValue());
                workflowExecution.setJobId((long)wF_SuperProcess_t.ProcessStepId.get().intValue());
                try {
                    workflowExecution.setInputs(String.valueOf(workflowElement.getNode("/workflow/inputs")));
                }
                catch (Exception exception) {
                    logger.error("failed to get elements for path /workflow/inputs", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                try {
                    workflowExecution.setVariables(String.valueOf(workflowElement.getNode("/workflow/variables")));
                }
                catch (Exception exception) {
                    logger.error("failed to get elements for path /workflow/variables", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                workflowExecution.setStatus(ProcessStatus.SUSPENDED.toInt());
            }
        } else {
            for (ProcessContext processContext : workflowManager.getWorkflow().getChildProcesses()) {
                WorkflowExecution workflowExecution = new WorkflowExecution();
                getWorkflowExecutionResp.getExecution().getChildren().add(workflowExecution);
                workflowExecution.getEntity().setWorkflowId(processContext.getWorkflowId());
                workflowExecution.getEntity().setWorkflowName(processContext.getName());
                workflowExecution.setProcessId(processContext.getSuperProcessId().intValue());
                workflowExecution.setJobId((long)processContext.getProcessStepId().intValue());
                workflowExecution.setInputs(processContext.getWorkflowExecution().getInputs().toString());
                workflowExecution.setVariables(processContext.getWorkflowExecution().getVariables().toString());
                workflowExecution.setStatus(processContext.getStatus().toInt());
            }
        }
        return getWorkflowExecutionResp;
    }

    @Override
    public void handle(WorkflowRequest workflowRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        asyncWorkflowResponse.setResponse(this.handle(workflowRequest));
    }
}

