/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.logger;

import commvault.cte.workflow.logger.HeaderProperty;
import commvault.cte.workflow.logger.LoggerLevel;
import java.util.ArrayList;
import java.util.List;

public class LogConfig {
    public static final int DEFAULT_MAX_SIZE = 5;
    public static final int DEFAULT_NUMBER_FILES = 2;
    public static final LoggerLevel DEFAULT_LEVEL = LoggerLevel.INFO;
    private String applicationName;
    private String fileName;
    private int maxSize = 5;
    private int numFiles = 2;
    private LoggerLevel level = DEFAULT_LEVEL;
    private List<HeaderProperty> headerProperties = new ArrayList<HeaderProperty>();
    private boolean debugLog = false;

    public LogConfig(String string, String string2, boolean bl) {
        this.applicationName = string;
        this.fileName = string2;
        this.debugLog = bl;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int n) {
        this.numFiles = n;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggerLevel loggerLevel) {
        this.level = loggerLevel;
    }

    public void setLevel(int n) {
        this.level = LoggerLevel.fromInt(n);
    }

    public void addFileHeader(String string, String string2) {
        this.headerProperties.add(new HeaderProperty(string, string2));
    }

    public void addDateHeader(String string) {
        HeaderProperty headerProperty = new HeaderProperty(string, null);
        headerProperty.setDate(true);
        this.headerProperties.add(headerProperty);
    }

    protected List<HeaderProperty> getHeaderProperties() {
        return this.headerProperties;
    }
}

