/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.logger;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTEDebugFormat;
import commvault.cte.workflow.logger.CTELogFormat;
import commvault.cte.workflow.logger.CTERecord;
import commvault.cte.workflow.logger.CVFileHandler;
import commvault.cte.workflow.logger.LogConfig;
import commvault.cte.workflow.logger.LoggerFile;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.logger.SimpleLog;
import commvault.cte.workflow.logger.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CTELogger {
    private static int SIZE_MOD = 0x100000;
    private static CTELogger console = new CTELogger();
    private static CTELogger instance;
    private final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("LoggerThread-" + String.valueOf(this.count.incrementAndGet()));
            return thread;
        }
    });
    private CVFileHandler fileHandler;
    private int pid;
    private volatile LoggerLevel level = LoggerLevel.INFO;
    private Set<Long> disabledJobs = new HashSet<Long>();
    private Map<Long, LoggerFile> jobLoggers = new HashMap<Long, LoggerFile>();
    private CTELogFormat formatter = new CTELogFormat();
    private CTEDebugFormat debugFormatter = new CTEDebugFormat();
    private boolean debugLog;

    public static void createInstance(LogConfig logConfig) {
        instance = new CTELogger(logConfig);
    }

    public static CTELogger getInstance() {
        if (instance == null) {
            return console;
        }
        return instance;
    }

    public static LoggerInstance getLogger(Class clazz) {
        CTELogger cTELogger = CTELogger.getInstance();
        cTELogger.getClass();
        return cTELogger.new LoggerInstance(clazz);
    }

    public static JobLoggerInstance getLogger(Class clazz, long l) {
        CTELogger cTELogger = CTELogger.getInstance();
        cTELogger.getClass();
        return cTELogger.new JobLoggerInstance(clazz, l);
    }

    public CTELogger() {
        try {
            this.pid = Utils.getProcessId();
        }
        catch (NumberFormatException numberFormatException) {
            this.log(LoggerLevel.ERROR, CTELogger.class, null, "error retrieving pid");
            this.log(LoggerLevel.ERROR, CTELogger.class, numberFormatException);
        }
    }

    public CTELogger(LogConfig logConfig) {
        this.debugLog = logConfig.isDebugLog();
        this.fileHandler = new CVFileHandler(logConfig.getFileName(), logConfig.getMaxSize() * SIZE_MOD, logConfig.getNumFiles(), true, logConfig.getHeaderProperties());
        try {
            this.fileHandler.openFiles();
        }
        catch (Exception exception) {
            this.log(LoggerLevel.ERROR, CTELogger.class, null, "error intializing log file handler");
            this.log(LoggerLevel.ERROR, CTELogger.class, exception);
        }
        this.setLevel(logConfig.getLevel());
        try {
            this.pid = Utils.getProcessId();
        }
        catch (NumberFormatException numberFormatException) {
            this.log(LoggerLevel.ERROR, CTELogger.class, null, "error retrieving pid");
            this.log(LoggerLevel.ERROR, CTELogger.class, numberFormatException);
        }
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.setLevel(LoggerLevel.fromInt(n));
    }

    public void setLevel(LoggerLevel loggerLevel) {
        this.level = loggerLevel;
    }

    public int getNumFiles() {
        if (this.fileHandler != null) {
            return this.fileHandler.getCount();
        }
        return 0;
    }

    public void setNumFiles(int n) {
        if (this.fileHandler != null) {
            this.fileHandler.setCount(n);
        }
    }

    public int getMaxSize() {
        if (this.fileHandler != null) {
            return this.fileHandler.getLimit() / SIZE_MOD;
        }
        return 0;
    }

    public void setMaxSize(int n) {
        if (this.fileHandler != null) {
            this.fileHandler.setLimit(n * SIZE_MOD);
        }
    }

    public void log(LoggerLevel loggerLevel, Class clazz, Throwable throwable) {
        this.log(loggerLevel, clazz.getSimpleName(), null, null, throwable);
    }

    public void log(LoggerLevel loggerLevel, Class clazz, Long l, String string) {
        this.log(loggerLevel, clazz.getSimpleName(), l, string);
    }

    public void log(LoggerLevel loggerLevel, String string, Long l, String string2) {
        this.log(loggerLevel, string, l, string2, null);
    }

    public void log(LoggerLevel loggerLevel, String string, Long l, String string2, Throwable throwable) {
        this.log(loggerLevel, string, l, string2, throwable, true);
    }

    public void log(LoggerLevel loggerLevel, String string, Long l, String string2, Throwable throwable, boolean bl) {
        Runnable runnable;
        if (loggerLevel.toInt() > this.getLevel().toInt()) {
            return;
        }
        CTERecord cTERecord = new CTERecord(this.pid, Thread.currentThread().getId(), string, loggerLevel, string2, throwable);
        if (Thread.currentThread() instanceof WorkflowThread) {
            runnable = (WorkflowThread)Thread.currentThread();
            ProcessContext processContext = ((WorkflowThread)runnable).getWorkflowContext().getParent();
            if (!processContext.isRoot()) {
                while (!processContext.isRoot()) {
                    if (processContext.getProcessName() != null && processContext.getProcessName().length() > 0) {
                        cTERecord.getProcessList().add(processContext.getProcessName());
                    }
                    processContext = processContext.getParent();
                }
                if (cTERecord.getProcessList().size() > 0) {
                    Collections.reverse(cTERecord.getProcessList());
                }
            }
            if (((WorkflowThread)runnable).getWorkflowContext() instanceof ActivityContext) {
                cTERecord.getProcessList().add(((WorkflowThread)runnable).getWorkflowContext().getFriendlyName());
            }
            if (l == null) {
                l = ((WorkflowThread)runnable).getJobId();
            }
            if (this.debugLog && processContext.isDebug()) {
                processContext.addDebugMessage(this.debugFormatter.format(cTERecord, ""));
            }
        }
        cTERecord.setJobId(l);
        if (!this.disabledJobs.contains(l) || loggerLevel == LoggerLevel.ERROR) {
            runnable = new Publisher(l, cTERecord);
            if (bl) {
                this.EXECUTOR.execute(runnable);
            } else {
                ((Publisher)runnable).run();
            }
        }
    }

    public void setCTELogFile(long l, String string) throws Exception {
        if (this.jobLoggers.containsKey(l)) {
            this.resetCTELogFile(l);
        }
        SimpleLog simpleLog = new SimpleLog(string);
        this.jobLoggers.put(l, simpleLog);
    }

    public void resetCTELogFile(long l) {
        LoggerFile loggerFile = this.jobLoggers.get(l);
        if (loggerFile != null) {
            try {
                loggerFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jobLoggers.remove(l);
        }
    }

    public void close() {
        this.EXECUTOR.shutdown();
        try {
            this.EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fileHandler != null) {
            try {
                this.fileHandler.close();
                this.fileHandler = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class Publisher
    implements Runnable {
        private Long jobId;
        private List<CTERecord> records;

        public Publisher(Long l, CTERecord cTERecord) {
            this.jobId = l;
            this.records = Arrays.asList(cTERecord);
        }

        public Publisher(Long l, List<CTERecord> list) {
            this.jobId = l;
            this.records = list;
        }

        @Override
        public void run() {
            for (CTERecord cTERecord : this.records) {
                String string = CTELogger.this.formatter.format(cTERecord);
                if (cTERecord.getLevel() == LoggerLevel.ERROR) {
                    System.err.print(string);
                } else {
                    System.out.print(string);
                }
                LoggerFile loggerFile = null;
                if (this.jobId != null) {
                    loggerFile = (LoggerFile)CTELogger.this.jobLoggers.get(this.jobId);
                }
                if (loggerFile == null) {
                    loggerFile = CTELogger.this.fileHandler;
                }
                if (loggerFile == null) continue;
                try {
                    loggerFile.publish(string);
                }
                catch (Exception exception) {}
            }
        }
    }

    public class LoggerInstance {
        private final Class clazz;

        public LoggerInstance(Class clazz) {
            this.clazz = clazz;
        }

        public LoggerLevel getLevel() {
            return CTELogger.this.getLevel();
        }

        public boolean isDebug() {
            return CTELogger.this.getLevel().toInt() >= LoggerLevel.DEBUG.toInt();
        }

        private String format(String string, Object ... objectArray) {
            try {
                if (objectArray != null && objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null || !(objectArray[i] instanceof WorkflowElement)) continue;
                        objectArray[i] = ((WorkflowElement)objectArray[i]).clean(this.getLevel());
                    }
                    return String.format(string, objectArray);
                }
                return string;
            }
            catch (Throwable throwable) {
                CTELogger.this.log(LoggerLevel.ERROR, CTELogger.class, null, "failed to format log entry [" + string + "], error [" + throwable.getMessage() + "]");
                return "";
            }
        }

        public void info(String string) {
            this.debug(LoggerLevel.INFO, string, new Object[0]);
        }

        public void info(String string, Object ... objectArray) {
            this.debug(LoggerLevel.INFO, string, objectArray);
        }

        public void info(Long l, String string) {
            this.debugJob(LoggerLevel.INFO, l, string, new Object[0]);
        }

        public void info(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.INFO, l, string, objectArray);
        }

        public void details(String string) {
            this.debug(LoggerLevel.DETAILS, string, new Object[0]);
        }

        public void details(String string, Object ... objectArray) {
            this.debug(LoggerLevel.DETAILS, string, objectArray);
        }

        public void details(Long l, String string) {
            this.debugJob(LoggerLevel.DETAILS, l, string, new Object[0]);
        }

        public void details(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.DETAILS, l, string, objectArray);
        }

        public void debug(String string) {
            this.debug(LoggerLevel.DEBUG, string, new Object[0]);
        }

        public void debug(String string, Object ... objectArray) {
            this.debug(LoggerLevel.DEBUG, string, objectArray);
        }

        public void debug(Long l, String string) {
            this.debugJob(LoggerLevel.DEBUG, l, string, new Object[0]);
        }

        public void debug(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.DEBUG, l, string, objectArray);
        }

        public void xml(String string) {
            this.debug(LoggerLevel.XML, string, new Object[0]);
        }

        public void xml(String string, Object ... objectArray) {
            this.debug(LoggerLevel.XML, string, objectArray);
        }

        public void xml(Long l, String string) {
            this.debugJob(LoggerLevel.XML, l, string, new Object[0]);
        }

        public void xml(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.XML, l, string, objectArray);
        }

        public void trace(String string) {
            this.debug(LoggerLevel.TRACE, string, new Object[0]);
        }

        public void trace(String string, Object ... objectArray) {
            this.debug(LoggerLevel.TRACE, string, objectArray);
        }

        public void trace(Long l, String string) {
            this.debugJob(LoggerLevel.TRACE, l, string, new Object[0]);
        }

        public void trace(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.TRACE, l, string, objectArray);
        }

        public void warn(String string) {
            this.debug(LoggerLevel.WARNING, string, new Object[0]);
        }

        public void warn(String string, Object ... objectArray) {
            this.debug(LoggerLevel.WARNING, string, objectArray);
        }

        public void warn(Long l, String string) {
            this.debugJob(LoggerLevel.WARNING, l, string, new Object[0]);
        }

        public void warn(Long l, String string, Object ... objectArray) {
            this.debugJob(LoggerLevel.WARNING, l, string, objectArray);
        }

        public void error(String string) {
            this.debug(LoggerLevel.ERROR, string, new Object[0]);
        }

        public void error(Long l, String string) {
            this.debugJob(LoggerLevel.ERROR, l, string, new Object[0]);
        }

        public void error(String string, Throwable throwable) {
            this.error(null, string, throwable);
        }

        public void error(Long l, String string, Throwable throwable) {
            CTELogger.this.log(CTELogger.this.level, this.clazz.getSimpleName(), l, string, throwable);
        }

        public void errorNow(String string, Throwable throwable) {
            CTELogger.this.log(CTELogger.this.level, this.clazz.getSimpleName(), null, string, throwable, false);
        }

        public void debugJob(LoggerLevel loggerLevel, Long l, String string, Object ... objectArray) {
            CTELogger.this.log(loggerLevel, this.clazz, l, this.format(string, objectArray));
        }

        public void debug(LoggerLevel loggerLevel, String string, Object ... objectArray) {
            CTELogger.this.log(loggerLevel, this.clazz, null, this.format(string, objectArray));
        }

        public void logAll(LoggerLevel loggerLevel, String ... stringArray) {
            if (loggerLevel.toInt() > this.getLevel().toInt()) {
                return;
            }
            ArrayList<CTERecord> arrayList = new ArrayList<CTERecord>();
            for (String string : stringArray) {
                arrayList.add(new CTERecord(CTELogger.this.pid, Thread.currentThread().getId(), this.clazz.getSimpleName(), loggerLevel, string, null));
            }
            CTELogger.this.EXECUTOR.execute(new Publisher(null, arrayList));
        }

        public void error(Throwable throwable) {
            CTELogger.this.log(LoggerLevel.ERROR, this.clazz, throwable);
        }

        public void setJobDisabled(long l) {
            CTELogger.this.disabledJobs.add(l);
        }

        public void setJobEnabled(long l) {
            CTELogger.this.disabledJobs.remove(l);
        }

        public void setLogFile(long l, String string) throws Exception {
            CTELogger.this.setCTELogFile(l, string);
        }

        public void resetLogFile(long l) {
            CTELogger.this.resetCTELogFile(l);
        }

        public boolean isRedirected(long l) {
            return CTELogger.this.jobLoggers.containsKey(l);
        }
    }

    public class JobLoggerInstance {
        private final Class clazz;
        private final long jobId;

        public JobLoggerInstance(Class clazz, long l) {
            this.clazz = clazz;
            this.jobId = l;
        }

        public void info(String string) {
            CTELogger.this.log(LoggerLevel.INFO, this.clazz, (Long)this.jobId, string);
        }

        public void warn(String string) {
            CTELogger.this.log(LoggerLevel.WARNING, this.clazz, (Long)this.jobId, string);
        }

        public void error(String string) {
            CTELogger.this.log(LoggerLevel.ERROR, this.clazz, (Long)this.jobId, string);
        }
    }
}

