/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.logger;

import commvault.cte.workflow.logger.CTERecord;
import commvault.cte.workflow.logger.ColumnFormatter;
import commvault.cte.workflow.logger.LoggerLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class CTELogFormat {
    private static final String SPACE_CHAR = " ";
    private static final char LEFT_BRAKET = '[';
    private static final char RIGHT_BRAKET = ']';
    private static final String SUB_PROCESS = "->";
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final int MAX_MESSAGE_LENGTH = 65536;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd HH:mm:ss");
    private final ColumnFormatter fPid = new ColumnFormatter(4);
    private final ColumnFormatter fThread = new ColumnFormatter(3);
    private final ColumnFormatter fDate = new ColumnFormatter(8);
    private final ColumnFormatter fJobId = new ColumnFormatter(3);

    public synchronized String format(CTERecord cTERecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fPid.format(cTERecord.getPid()));
        stringBuffer.append(SPACE_CHAR);
        stringBuffer.append(this.fThread.format(cTERecord.getThreadId()));
        stringBuffer.append(SPACE_CHAR);
        stringBuffer.append(this.fDate.format(dateFormatter.format(Calendar.getInstance().getTime())));
        stringBuffer.append(SPACE_CHAR);
        if (cTERecord.getJobId() == null) {
            stringBuffer.append(this.fJobId.format("###"));
        } else if (cTERecord.getJobId() >= 0L) {
            stringBuffer.append(this.fJobId.format(cTERecord.getJobId()));
        } else {
            stringBuffer.append(this.fJobId.format("(" + cTERecord.getJobId() * -1L + ")"));
        }
        stringBuffer.append(SPACE_CHAR);
        if (cTERecord.getLocation() == null) {
            stringBuffer.append("###");
        } else {
            stringBuffer.append(cTERecord.getLocation());
        }
        stringBuffer.append(":");
        stringBuffer.append(SPACE_CHAR);
        if (cTERecord.getLevel() == LoggerLevel.WARNING || cTERecord.getLevel() == LoggerLevel.ERROR) {
            stringBuffer.append(cTERecord.getLevel().getName());
            stringBuffer.append(":");
            stringBuffer.append(SPACE_CHAR);
        }
        if (cTERecord.getProcessList() != null && cTERecord.getProcessList().size() > 0) {
            stringBuffer.append('[');
            for (int i = 0; i < cTERecord.getProcessList().size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(SUB_PROCESS);
                }
                stringBuffer.append(cTERecord.getProcessList().get(i).replaceAll("\\R", SPACE_CHAR));
            }
            stringBuffer.append(']');
            stringBuffer.append(SPACE_CHAR);
        }
        if (cTERecord.getMessage().length() > 65536) {
            stringBuffer.append(cTERecord.getMessage().substring(0, 65536));
        } else {
            stringBuffer.append(cTERecord.getMessage());
        }
        stringBuffer.append(LINE_SEPERATOR);
        if (cTERecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            cTERecord.getThrown().printStackTrace(printWriter);
            stringBuffer.append(stringWriter.toString()).append(LINE_SEPERATOR);
        }
        return stringBuffer.toString();
    }
}

