/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;

public class SetActivityInputs
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SetActivityInputs.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getActivityInputs() != null) {
            logger.info(activityContext.getJobId(), "starting activity with inputs [%s]", activityContext.getActivityInputs());
        } else {
            logger.info(activityContext.getJobId(), "starting activity with inputs []");
        }
        if (activityContext.getActivity() instanceof XMLInput) {
            logger.debug(activityContext.getJobId(), "activity is configured to handle it's own inputs, passing the xml string to it");
            String string = activityContext.getActivityInputs().toString();
            ((XMLInput)((Object)activityContext.getActivity())).setInputs(string);
        } else if (activityContext.getActivityInputs() != null) {
            try {
                activityContext.getMarshaller().unmarshal(activityContext.getActivityInputs(), activityContext.getActivity());
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error marshalling activity inputs [" + activityContext.getActivityInputs() + "]", evFailureException);
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
        }
    }
}

