/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;

public class RepeatActivity
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RepeatActivity.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getRepeatExpression() != null && activityContext.getRepeatExpression().length() > 0) {
            Object object;
            try {
                object = activityContext.getEvaluator().evaluate(activityContext.getRepeatExpression());
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error evaluating repeat expression");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            if (ExpressionUtils.parseBoolean(object)) {
                logger.info(activityContext.getJobId(), "repeat expression [%s] returned true, continuing activity", activityContext.getRepeatExpression());
                return;
            }
            logger.info(activityContext.getJobId(), "repeat expression [%s] returned false, will repeat in [%s] seconds", activityContext.getRepeatExpression(), activityContext.getRepeatInterval());
            activityContext.repeat();
        } else {
            logger.debug(activityContext.getJobId(), "activity contains no repeat expression");
        }
    }
}

