/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.logger.CTELogger;

public class ProcessOnExit
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ProcessOnExit.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getOnExit() != null && activityContext.getOnExit().getScript().length() > 0) {
            logger.debug(activityContext.getJobId(), "copying activity's outputs to execution dom");
            new RetrieveOutputs().executeHandler(activityContext);
            logger.info(activityContext.getJobId(), "processing onExit script [%s]", activityContext.getOnExit().getScript());
            try {
                activityContext.getEvaluator().evaluate(activityContext.getOnExit());
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error evaluating onExit script");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
        }
    }
}

