/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.CharacterEncoding;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.UTFEncodingEvalutor;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;

public class ProcessInputs
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ProcessInputs.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        WorkflowElement workflowElement = activityContext.getActivityInputs();
        if (activityContext.getActivity() instanceof ExpressionHandler) {
            try {
                logger.debug(activityContext.getJobId(), "activity is configured as an [%s] and will process all inputs expressions", ExpressionHandler.class.getName());
                ((ExpressionHandler)((Object)activityContext.getActivity())).processExpressions(activityContext, workflowElement);
            }
            catch (Exception exception) {
                logger.error(activityContext.getJobId(), "error processing expressions in activity inputs [" + workflowElement + "]", exception);
                activityContext.setFailureReason(exception.getMessage());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
        } else if (workflowElement != null) {
            try {
                if (activityContext.getActivity() instanceof CharacterEncoding) {
                    logger.debug(activityContext.getJobId(), "begin processing expressions for encoded inputs [%s]", workflowElement);
                    UTFEncodingEvalutor uTFEncodingEvalutor = new UTFEncodingEvalutor(activityContext.getEvaluator());
                    uTFEncodingEvalutor.processElement(workflowElement);
                }
                logger.debug(activityContext.getJobId(), "begin processing expressions for inputs [%s]", workflowElement);
                WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
                workflowEvaluator.processElement(workflowElement);
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error processing expressions in activity inputs [" + workflowElement + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
        } else {
            logger.debug(activityContext.getJobId(), "activity has no inputs to process");
        }
        activityContext.setActivityInputs(workflowElement);
    }
}

