/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.TransitionStatus;

public class DetermineTransitions
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DetermineTransitions.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getTransitions().length > 0) {
            logger.debug(activityContext.getJobId(), "determine transitions skipped because a transition has already been configured");
            return;
        }
        if (activityContext.getOutboundTransitions().length == 0) {
            logger.debug(activityContext.getJobId(), "there are no transitions to process from activity");
            return;
        }
        logger.debug(activityContext.getJobId(), "located [%s] transitions", activityContext.getOutboundTransitions().length);
        for (WorkflowTransition workflowTransition : activityContext.getOutboundTransitions()) {
            if (workflowTransition.isCommented()) {
                logger.warn(activityContext.getJobId(), "skipping transition [%s] since it has been commented", workflowTransition.getTargetActivity());
                continue;
            }
            if (activityContext.getStatus() == ProcessStatus.RUNNING) {
                if (workflowTransition.getStatus() == TransitionStatus.FAILED) {
                    logger.debug(activityContext.getJobId(), "skipping failure transition [%s] because activity execution was successful", workflowTransition.getTargetActivity());
                    continue;
                }
            } else if (workflowTransition.getStatus() == TransitionStatus.SUCCESSFULL || workflowTransition.getStatus() == TransitionStatus.SUCCESSFUL) {
                logger.debug(activityContext.getJobId(), "skipping successfull transition [%s] because activity execution failed", workflowTransition.getTargetActivity());
                continue;
            }
            if (workflowTransition.getCondition() != null && workflowTransition.getCondition().getScript().length() > 0) {
                try {
                    Object object = activityContext.getEvaluator().evaluate(workflowTransition.getCondition());
                    if (ExpressionUtils.parseBoolean(object)) {
                        logger.debug(activityContext.getJobId(), "taking transition [%s] since expression resulted in true", workflowTransition.getTargetActivity());
                        activityContext.addTransitionTo(workflowTransition);
                        return;
                    }
                    logger.debug(activityContext.getJobId(), "skipping transition [%s] because condition resulted in false", workflowTransition.getTargetActivity());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(activityContext.getJobId(), "error evaluating condition for transition [" + workflowTransition.getTargetActivity() + "]");
                }
                continue;
            }
            logger.debug(activityContext.getJobId(), "taking transition [%s] since expression resulted in true", workflowTransition.getTargetActivity());
            activityContext.addTransitionTo(workflowTransition);
            return;
        }
        if (WorkflowRegistry.getInstance().isFailOnNonDeterminedTransition()) {
            logger.error(activityContext.getJobId(), "could not determine transition from activity");
            activityContext.setFailureReason("failed to determine transition");
            activityContext.setStatus(ProcessStatus.PENDING);
        } else {
            logger.info(activityContext.getJobId(), "could not determine transition from activity");
        }
    }
}

